/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.plugin.auth;

import com.google.common.collect.ImmutableMap;
import com.tibbo.aggregate.common.plugin.auth.AuthenticationParams;
import com.tibbo.aggregate.common.plugin.auth.AuthenticationResult;
import java.util.Map;

public class BaseAuthenticationResult
implements AuthenticationResult {
    private final Map<String, String> environment;
    private final Map<AuthenticationParams, Object> body;
    private final AuthenticationState state;

    public BaseAuthenticationResult(AuthenticationState state, Map<AuthenticationParams, Object> body, Map<String, String> environment) {
        this.state = state;
        this.body = ImmutableMap.copyOf(body);
        this.environment = ImmutableMap.copyOf(environment);
    }

    public static BaseAuthenticationResult ofSuccessful() {
        return BaseAuthenticationResult.ofSuccessful("", "");
    }

    public static BaseAuthenticationResult ofSuccessful(String username, String login) {
        return new BaseAuthenticationResult(AuthenticationState.SUCCESS, (Map<AuthenticationParams, Object>)ImmutableMap.of((Object)((Object)AuthenticationParams.USERNAME), (Object)username, (Object)((Object)AuthenticationParams.LOGIN), (Object)login), (Map<String, String>)ImmutableMap.of());
    }

    public static BaseAuthenticationResult ofSuccessful(String username, String login, String accessToken) {
        return new BaseAuthenticationResult(AuthenticationState.SUCCESS, (Map<AuthenticationParams, Object>)ImmutableMap.of((Object)((Object)AuthenticationParams.USERNAME), (Object)username, (Object)((Object)AuthenticationParams.LOGIN), (Object)login, (Object)((Object)AuthenticationParams.TOKEN), (Object)accessToken), (Map<String, String>)ImmutableMap.of());
    }

    public static BaseAuthenticationResult ofSuccessful(ImmutableMap<AuthenticationParams, Object> body, ImmutableMap<String, String> environment) {
        return new BaseAuthenticationResult(AuthenticationState.SUCCESS, (Map<AuthenticationParams, Object>)body, (Map<String, String>)environment);
    }

    public static BaseAuthenticationResult ofFailed() {
        return new BaseAuthenticationResult(AuthenticationState.FAILED, (Map<AuthenticationParams, Object>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of());
    }

    public String getEnvironmentAttribute(String key) {
        return this.environment.get(key);
    }

    @Override
    public boolean isSuccessfull() {
        return this.state == AuthenticationState.SUCCESS;
    }

    @Override
    public String getUsername() {
        return (String)this.body.get((Object)AuthenticationParams.USERNAME);
    }

    @Override
    public String getLogin() {
        return (String)this.body.get((Object)AuthenticationParams.LOGIN);
    }

    @Override
    public Object getParam(AuthenticationParams key) {
        return this.body.get((Object)key);
    }

    static enum AuthenticationState {
        SUCCESS,
        FAILED;

    }
}

