/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.plugin.auth;

import com.google.common.collect.ImmutableMap;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.plugin.PluginException;
import com.tibbo.aggregate.common.plugin.auth.AuthenticationParams;
import com.tibbo.aggregate.common.plugin.auth.AuthenticationPlugin;
import com.tibbo.aggregate.common.plugin.auth.AuthenticationResult;
import java.util.Arrays;
import java.util.Map;

public class AuthenticationPluginDecorator
implements AuthenticationPlugin {
    private final AuthenticationPlugin delegate;

    public AuthenticationPluginDecorator(AuthenticationPlugin authenticationPlugin) {
        this.delegate = authenticationPlugin;
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getShortId() {
        return this.delegate.getShortId();
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @Override
    public int getSortIndex() {
        return this.delegate.getSortIndex();
    }

    @Override
    public void globalInit(Context rootContext) throws PluginException {
        this.delegate.globalInit(rootContext);
    }

    @Override
    public void userInit(Context userContext) throws PluginException {
        this.delegate.userInit(userContext);
    }

    @Override
    public void globalDeinit(Context rootContext) throws PluginException {
        this.delegate.globalDeinit(rootContext);
    }

    @Override
    public void userDeinit(Context userContext) throws PluginException {
        this.delegate.userDeinit(userContext);
    }

    @Override
    public void globalStart() throws PluginException {
        this.delegate.globalStart();
    }

    @Override
    public void globalStop() throws PluginException {
        this.delegate.globalStop();
    }

    @Override
    public Context createGlobalConfigContext(Context rootContext, boolean requestReboot, VariableDefinition ... properties) {
        return this.delegate.createGlobalConfigContext(rootContext, requestReboot, properties);
    }

    @Override
    public Context createUserConfigContext(Context userContext, boolean requestReboot, VariableDefinition ... properties) {
        return this.delegate.createUserConfigContext(userContext, requestReboot, properties);
    }

    @Override
    public Context getGlobalConfigContext() {
        return this.delegate.getGlobalConfigContext();
    }

    @Override
    public Context getUserConfigContext(String username) {
        return this.delegate.getUserConfigContext(username);
    }

    @Override
    public AuthenticationResult authenticate(Map<AuthenticationParams, Object> params) throws PluginException, ContextException {
        try {
            AuthenticationResult authenticationResult = this.delegate.authenticate(params);
            return authenticationResult;
        }
        finally {
            if (params.get((Object)AuthenticationParams.PASSWORD) != null) {
                Arrays.fill((char[])params.get((Object)AuthenticationParams.PASSWORD), '\u0000');
            }
        }
    }

    @Override
    public boolean isAuthenticationByPassword() {
        return this.delegate.isAuthenticationByPassword();
    }

    @Override
    public AuthenticationResult refreshToken(ImmutableMap<AuthenticationParams, Object> params) throws ContextException {
        return this.delegate.refreshToken(params);
    }

    @Override
    public void logout(Map<AuthenticationParams, Object> params) throws ContextException {
        this.delegate.logout(params);
    }
}

