/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.plugin;

import com.tibbo.aggregate.common.AggreGateException;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.plugin.BasePlugin;
import com.tibbo.aggregate.common.plugin.ExtensionsPlugin;
import com.tibbo.aggregate.common.security.Permissions;
import com.tibbo.aggregate.common.util.ReflectUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.java.plugin.ObjectFactory;
import org.java.plugin.Plugin;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.util.ExtendedProperties;

public abstract class PluginDirector {
    public static final String PLUGIN_DIRS_SEPARATOR = ",";
    public static final String PLUGIN_FILE_EXTENSION = ".jar";
    public static final String EXTENSIONS_PLUGIN_ID = "com.tibbo.aggregate.common.plugin.extensions";
    private PluginManager pluginManager;
    private ExtensionsPlugin extensionsPlugin;
    private Collection<String> allowedPlugins;
    private final Map<String, String> pluginIdMap = new LinkedHashMap<String, String>();

    public PluginDirector(String homeDir, String additionalPluginDirs, Collection<String> allowedPlugins) throws AggreGateException {
        this.allowedPlugins = allowedPlugins;
        try {
            String pluginDirList = this.getPluginDirList(homeDir, additionalPluginDirs);
            this.updatePlugins();
            this.loadPlugins(pluginDirList);
            this.checkIntegrity();
            Plugin extentionsPlugin = this.pluginManager.getPlugin(EXTENSIONS_PLUGIN_ID);
            if (extentionsPlugin == null) {
                throw new AggreGateException("Error loading extensions plugin (ID: 'com.tibbo.aggregate.common.plugin.extensions')");
            }
            this.extensionsPlugin = (ExtensionsPlugin)extentionsPlugin;
        }
        catch (Exception ex) {
            throw new AggreGateException(Cres.get().getString("pluginsErrStartingSubsystem") + ex.getMessage(), ex);
        }
    }

    public PluginDirector(String homeDir) throws AggreGateException {
        try {
            String pluginDirList = this.getPluginDirList(homeDir, null);
            this.updatePlugins();
            this.loadPlugins(pluginDirList);
        }
        catch (Exception ex) {
            throw new AggreGateException(Cres.get().getString("pluginsErrStartingSubsystem") + ex.getMessage(), ex);
        }
    }

    protected abstract void updatePlugins();

    public abstract ContextManager getContextManager();

    public abstract CallerController getCallerController();

    public abstract Context createGlobalConfigContext(BasePlugin var1, Context var2, boolean var3, Permissions var4, VariableDefinition ... var5);

    public abstract Context createUserConfigContext(BasePlugin var1, Context var2, boolean var3, VariableDefinition ... var4);

    private void loadPlugins(String dirList) throws AggreGateException {
        try {
            Log.PLUGINS.debug((Object)("Loading all plugins from the following directories: " + dirList));
            StringTokenizer st = new StringTokenizer(dirList, PLUGIN_DIRS_SEPARATOR, false);
            LinkedList<PluginLocationImpl> pluginLocations = new LinkedList<PluginLocationImpl>();
            while (st.hasMoreTokens()) {
                String sourceDir = st.nextToken().trim();
                Log.PLUGINS.debug((Object)("Loading all plugins from directory: " + sourceDir));
                File folder = new File(sourceDir).getCanonicalFile();
                if (!folder.isDirectory()) {
                    Log.PLUGINS.warn((Object)("Plugins folder " + folder + " doesn't exist"));
                    continue;
                }
                File[] pluginFiles = folder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile() && file.getName().endsWith(PluginDirector.PLUGIN_FILE_EXTENSION);
                    }
                });
                for (int i = 0; i < pluginFiles.length; ++i) {
                    URL manifest = new URL("jar:file:" + pluginFiles[i].getAbsolutePath() + "!/plugin.xml");
                    Log.PLUGINS.debug((Object)("Located plugin " + pluginFiles[i].getName() + ", manifest file " + manifest));
                    pluginLocations.add(new PluginLocationImpl(manifest, new URL("file:" + pluginFiles[i])));
                }
            }
            ExtendedProperties config = new ExtendedProperties();
            this.pluginManager = ObjectFactory.newInstance((ExtendedProperties)config).createManager();
            this.pluginManager.publishPlugins((PluginManager.PluginLocation[])pluginLocations.toArray(new PluginLocationImpl[pluginLocations.size()]));
        }
        catch (Exception ex) {
            throw new AggreGateException(Cres.get().getString("pluginsErrLoading") + ex.getMessage(), ex);
        }
    }

    private String getPluginDirList(String homeDir, String additionalPluginDirs) throws AggreGateException, IOException {
        Log.CORE.debug((Object)"Starting plugins subsystem");
        String mainPluginsDir = homeDir + "plugins/";
        Log.PLUGINS.debug((Object)("Main plugins directory: " + mainPluginsDir));
        File[] pluginDirs = new File(mainPluginsDir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        String pluginDirList = "";
        int num = 0;
        if (pluginDirs != null) {
            for (File dir : pluginDirs) {
                pluginDirList = pluginDirList + (num > 0 ? PLUGIN_DIRS_SEPARATOR : "") + dir.getCanonicalPath();
                ++num;
            }
        }
        if (additionalPluginDirs != null) {
            pluginDirList = pluginDirList + PLUGIN_DIRS_SEPARATOR + additionalPluginDirs;
        }
        return pluginDirList;
    }

    protected void checkIntegrity() throws AggreGateException {
        this.updateDeprecatedPrerequisites();
        IntegrityCheckReport integrityCheckReport = this.pluginManager.getRegistry().checkIntegrity(this.pluginManager.getPathResolver());
        Log.PLUGINS.debug((Object)("Plugin integrity check complete: errors - " + integrityCheckReport.countErrors() + ", warnings - " + integrityCheckReport.countWarnings()));
        if (integrityCheckReport.countErrors() != 0) {
            Log.PLUGINS.warn((Object)this.integrityCheckReportToString(integrityCheckReport));
            throw new AggreGateException(Cres.get().getString("pluginsIntegrityCheckFailed"));
        }
    }

    private String integrityCheckReportToString(IntegrityCheckReport report) {
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin integrity check report\n");
        for (IntegrityCheckReport.ReportItem item : report.getItems()) {
            if (item.getCode() == IntegrityCheckReport.Error.NO_ERROR) continue;
            buf.append("\tSeverity=").append(item.getSeverity()).append(", code=").append(item.getCode()).append(", message=").append(item.getMessage()).append(", source=").append(item.getSource()).append("\n");
        }
        return buf.toString();
    }

    public void stop() throws AggreGateException {
        try {
            this.pluginManager.shutdown();
            System.gc();
        }
        catch (Exception ex) {
            Log.PLUGINS.warn((Object)"Error stopping plugins subsystem", (Throwable)ex);
        }
    }

    protected String convertId(String id) {
        if (this.pluginIdMap.containsKey(id)) {
            return this.pluginIdMap.get(id);
        }
        return id;
    }

    public Plugin getExistingPlugin(String id) {
        if (!this.isPluginAllowed(id = this.convertId(id))) {
            throw new IllegalArgumentException(MessageFormat.format(Cres.get().getString("pluginNotAvail"), id));
        }
        try {
            Plugin plugin = this.pluginManager.getPlugin(id);
            plugin.getClass().getClassLoader().loadClass(plugin.getDescriptor().getPluginClassName());
            return plugin;
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(MessageFormat.format(Cres.get().getString("pluginNotAvail"), id) + ex.getMessage(), ex);
        }
    }

    public Plugin createNewPlugin(String id) {
        if (!this.isPluginAllowed(id = this.convertId(id))) {
            throw new IllegalArgumentException(MessageFormat.format(Cres.get().getString("pluginNotAvail"), id));
        }
        BasePlugin plugin = (BasePlugin)this.getExistingPlugin(id);
        try {
            Log.PLUGINS.debug((Object)("Creating new instance of plugin " + id));
            BasePlugin instance = (BasePlugin)plugin.getClass().newInstance();
            instance.setId(plugin.getId());
            instance.setDescription(plugin.getDescription());
            instance.setPluginDirector(this);
            return instance;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    protected boolean isPluginAllowed(String id) {
        return this.allowedPlugins == null || this.allowedPlugins.contains(id);
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public ClassLoader getPluginClassLoader(String id) throws PluginLifecycleException {
        Plugin plugin = this.pluginManager.getPlugin(id);
        if (plugin == null) {
            return null;
        }
        return this.pluginManager.getPluginClassLoader(plugin.getDescriptor());
    }

    public boolean isPluginAvailable(String id) {
        id = this.convertId(id);
        if (!this.pluginManager.getRegistry().isPluginDescriptorAvailable(id)) {
            return false;
        }
        PluginDescriptor pd = this.pluginManager.getRegistry().getPluginDescriptor(id);
        return this.isPluginAllowed(id) && !this.pluginManager.isBadPlugin(pd) && this.pluginManager.isPluginEnabled(pd);
    }

    protected ExtensionsPlugin getExtensionsPlugin() {
        return this.extensionsPlugin;
    }

    public Map<String, String> getPluginIdMap() {
        return this.pluginIdMap;
    }

    private void updateDeprecatedPrerequisites() {
        String resourcePacksId = "com.tibbo.linkserver.plugin.context.resource-packs";
        String applicationsId = "com.tibbo.linkserver.plugin.context.applications";
        Map<String, String> oldToNewIdMap = Collections.singletonMap(resourcePacksId, applicationsId);
        try {
            for (PluginDescriptor descriptor : this.pluginManager.getRegistry().getPluginDescriptors()) {
                Map prerequisites = (Map)ReflectUtils.getPrivateField(descriptor, "pluginPrerequisites");
                HashMap oldPrerequisiteMap = new HashMap();
                for (String oldPrerequisiteId : oldToNewIdMap.keySet()) {
                    if (!prerequisites.containsKey(oldPrerequisiteId)) continue;
                    oldPrerequisiteMap.put(oldPrerequisiteId, prerequisites.get(oldPrerequisiteId));
                }
                for (String oldPrerequisiteId : oldPrerequisiteMap.keySet()) {
                    String newPrerequisiteId = oldToNewIdMap.get(oldPrerequisiteId);
                    PluginPrerequisite oldPrerequisite = (PluginPrerequisite)prerequisites.get(oldPrerequisiteId);
                    Object model = ReflectUtils.getPrivateField(oldPrerequisite, "model");
                    ReflectUtils.setPrivateField(model, "pluginId", newPrerequisiteId);
                    ReflectUtils.setPrivateField(model, "id", "prerequisite:" + newPrerequisiteId);
                    prerequisites.put(newPrerequisiteId, oldPrerequisite);
                    prerequisites.remove(oldPrerequisiteId);
                }
            }
        }
        catch (Exception ex) {
            Log.PLUGINS.warn((Object)"Updating deprecated prerequisites failed", (Throwable)ex);
        }
    }

    private class PluginLocationImpl
    implements PluginManager.PluginLocation {
        private final URL manifest;
        private final URL plugin;

        public PluginLocationImpl(URL manifest, URL plugin) {
            this.manifest = manifest;
            this.plugin = plugin;
        }

        public URL getManifestLocation() {
            return this.manifest;
        }

        public URL getContextLocation() {
            return this.plugin;
        }
    }
}

