/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.plugin;

import com.tibbo.aggregate.common.AggreGateException;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.plugin.BasePlugin;
import com.tibbo.aggregate.common.plugin.ComponentPlugin;
import com.tibbo.aggregate.common.plugin.PluginDirector;
import com.tibbo.aggregate.common.security.Permissions;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import org.java.plugin.Plugin;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.ManifestProcessingException;

public class ComponentPluginDirector
extends PluginDirector {
    private static final String EXTENSION_POINT_COMPONENT = "component";
    private static final String EXTENSIONS_PLUGIN_DESCRIPTOR = "plugin.xml";

    public ComponentPluginDirector(String homeDir) throws AggreGateException {
        super(homeDir);
        try {
            this.getPluginManager().getRegistry().register(new URL[]{this.getClass().getResource(EXTENSIONS_PLUGIN_DESCRIPTOR)});
            this.checkIntegrity();
        }
        catch (ManifestProcessingException ex) {
            Log.WIDGETS.error((Object)("Error creating plugin director: " + ex.getMessage()), (Throwable)ex);
        }
    }

    public Collection getPlugins(String extensionPoint) {
        LinkedList<Plugin> res = new LinkedList<Plugin>();
        for (Extension ext : this.getExtensionPoint(extensionPoint).getConnectedExtensions()) {
            Plugin plugin;
            String id = ext.getDeclaringPluginDescriptor().getId();
            if (!this.isPluginAllowed(id) || !ComponentPlugin.class.isAssignableFrom((plugin = this.getExistingPlugin(id)).getClass())) continue;
            res.add(plugin);
        }
        return res;
    }

    @Override
    protected void updatePlugins() {
    }

    protected ExtensionPoint getExtensionPoint(String name) {
        return this.getPluginManager().getRegistry().getExtensionPoint("com.tibbo.aggregate.common.plugin.extensions", name);
    }

    public Collection<ComponentPlugin> getComponentPlugins() {
        return this.getPlugins(EXTENSION_POINT_COMPONENT);
    }

    @Override
    public ContextManager getContextManager() {
        return null;
    }

    @Override
    public CallerController getCallerController() {
        return null;
    }

    @Override
    public Context createGlobalConfigContext(BasePlugin plugin, Context rootContext, boolean requestReboot, Permissions permissions, VariableDefinition ... properties) {
        return null;
    }

    @Override
    public Context createUserConfigContext(BasePlugin plugin, Context userContext, boolean requestReboot, VariableDefinition ... properties) {
        return null;
    }
}

