/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.plugin;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.plugin.AggreGatePlugin;
import com.tibbo.aggregate.common.plugin.PluginDirector;
import com.tibbo.aggregate.common.plugin.PluginException;
import com.tibbo.aggregate.common.security.Permissions;
import com.tibbo.aggregate.common.security.ServerPermissionChecker;
import org.java.plugin.Plugin;

public abstract class BasePlugin
extends Plugin
implements AggreGatePlugin,
Comparable<AggreGatePlugin> {
    public static final int INDEX_HIGHEST = 400;
    public static final int INDEX_VERY_HIGH = 300;
    public static final int INDEX_HIGH = 200;
    public static final int INDEX_HIGHER = 100;
    public static final int INDEX_NORMAL = 0;
    public static final int INDEX_LOWER = -100;
    public static final int INDEX_LOW = -200;
    public static final int INDEX_VERY_LOW = -300;
    public static final int INDEX_LOWEST = -400;
    private PluginDirector pluginDirector;
    private String id;
    private String description;
    private int index = 0;

    public BasePlugin() {
    }

    public BasePlugin(String description) {
        this();
        this.description = description;
    }

    @Override
    public String getId() {
        return this.id != null ? this.id : super.getDescriptor().getId();
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getShortId() {
        String id = this.getId();
        int index = id.lastIndexOf(".");
        return index != -1 ? id.substring(index + 1) : id;
    }

    @Override
    public String getDescription() {
        return this.description != null ? this.description : (this.getDescriptor().getDocumentation() != null ? this.getDescriptor().getDocumentation().getText() : null);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PluginDirector getPluginDirector() {
        return this.pluginDirector;
    }

    public void setPluginDirector(PluginDirector pluginDirector) {
        this.pluginDirector = pluginDirector;
    }

    @Override
    public Context createGlobalConfigContext(Context rootContext, boolean requestReboot, VariableDefinition ... properties) {
        return this.pluginDirector.createGlobalConfigContext(this, rootContext, requestReboot, ServerPermissionChecker.getAdminPermissions(), properties);
    }

    public Context createGlobalConfigContext(Context rootContext, boolean requestReboot, Permissions permissions, VariableDefinition ... properties) {
        return this.pluginDirector.createGlobalConfigContext(this, rootContext, requestReboot, permissions, properties);
    }

    @Override
    public Context createUserConfigContext(Context userContext, boolean requestReboot, VariableDefinition ... properties) {
        return this.pluginDirector.createUserConfigContext(this, userContext, requestReboot, properties);
    }

    @Override
    public Context getGlobalConfigContext() {
        return this.pluginDirector.getContextManager().get(ContextUtils.pluginGlobalConfigContextPath(this.getId()), this.pluginDirector.getCallerController());
    }

    @Override
    public Context getUserConfigContext(String username) {
        return this.pluginDirector.getContextManager().get(ContextUtils.pluginUserConfigContextPath(username, this.getId()), this.pluginDirector.getCallerController());
    }

    @Override
    public int getSortIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int compareTo(AggreGatePlugin other) {
        if (this.index != other.getSortIndex()) {
            return other.getSortIndex() - this.index;
        }
        return this.getId().compareTo(other.getId());
    }

    protected void doStart() throws Exception {
        Log.PLUGINS.debug((Object)("Starting plugin: " + this.getDescription() + " (" + this.getId() + ")"));
    }

    protected void doStop() throws Exception {
        Log.PLUGINS.debug((Object)("Stopping plugin: " + this.getDescription() + " (" + this.getId() + ")"));
    }

    @Override
    public void globalInit(Context rootContext) throws PluginException {
    }

    @Override
    public void globalDeinit(Context rootContext) throws PluginException {
    }

    @Override
    public void userInit(Context userContext) throws PluginException {
    }

    @Override
    public void userDeinit(Context userContext) throws PluginException {
    }

    @Override
    public void globalStart() throws PluginException {
    }

    @Override
    public void globalStop() throws PluginException {
    }
}

