/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter.converter;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.filter.ColumnName;
import com.tibbo.aggregate.common.filter.Expression;

public class FunctionConverters {
    public static DataRecord contains(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "CONTAINS", String.class);
    }

    public static DataRecord startWith(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "BEGINS_WITH", String.class);
    }

    public static DataRecord endsWith(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "ENDS_WITH", String.class);
    }

    public static DataRecord onAfter(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "ON_OR_AFTER", String.class);
    }

    public static DataRecord onBefore(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "ON_OR_BEFORE", String.class);
    }

    public static DataRecord on(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "ON", String.class);
    }

    public static DataRecord thisHour(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeSingleColumnOperation(expression, dataRecord, "THIS_HOUR");
    }

    public static DataRecord yesterday(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeSingleColumnOperation(expression, dataRecord, "YESTERDAY");
    }

    public static DataRecord today(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeSingleColumnOperation(expression, dataRecord, "TODAY");
    }

    public static DataRecord tomorrow(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeSingleColumnOperation(expression, dataRecord, "TOMORROW");
    }

    public static DataRecord thisWeek(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeSingleColumnOperation(expression, dataRecord, "THIS_WEEK");
    }

    public static DataRecord thisMonth(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeSingleColumnOperation(expression, dataRecord, "THIS_MONTH");
    }

    public static DataRecord thisYear(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeSingleColumnOperation(expression, dataRecord, "THIS_YEAR");
    }

    public static DataRecord lastHours(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "LAST_X_HOURS", Number.class);
    }

    public static DataRecord nextHours(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "NEXT_X_HOURS", Number.class);
    }

    public static DataRecord lastDays(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "LAST_X_DAYS", Number.class);
    }

    public static DataRecord nextDays(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "NEXT_X_DAYS", Number.class);
    }

    public static DataRecord lastWeeks(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "LAST_X_WEEKS", Number.class);
    }

    public static DataRecord nextWeeks(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "NEXT_X_WEEKS", Number.class);
    }

    public static DataRecord lastMonths(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "LAST_X_MONTHS", Number.class);
    }

    public static DataRecord nextMonths(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "NEXT_X_MONTHS", Number.class);
    }

    public static DataRecord lastYears(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "LAST_X_YEARS", Number.class);
    }

    public static DataRecord nextYears(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeColumnOperation(expression, dataRecord, "NEXT_X_YEARS", Number.class);
    }

    public static DataRecord isNull(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeSingleColumnOperation(expression, dataRecord, "IS_NULL");
    }

    public static DataRecord isNotNull(Expression expression, DataRecord dataRecord) {
        return FunctionConverters.makeSingleColumnOperation(expression, dataRecord, "IS_NOT_NULL");
    }

    public static DataRecord includedIn(Expression expression, DataRecord dataRecord) {
        Expression columnExpression = expression.getChildren()[0];
        if (!(columnExpression instanceof ColumnName)) {
            throw new IllegalArgumentException("Column reference is expected. Operation included in");
        }
        ColumnName columnName = (ColumnName)columnExpression;
        StringBuilder values = new StringBuilder();
        boolean first = true;
        int length = expression.getChildren().length;
        for (int i = 1; i < length; ++i) {
            Object value = expression.getChildren()[i].evaluate();
            if (!first) {
                values.append(',');
            }
            values.append(value.toString());
            first = false;
        }
        dataRecord.setValue("operation", (Object)"IN");
        dataRecord.setValue("column", (Object)columnName.getName());
        String value = values.toString();
        if (length == 2) {
            value = "'" + value + "'";
        }
        dataRecord.setValue("value", (Object)value);
        return dataRecord;
    }

    private static DataRecord makeSingleColumnOperation(Expression expression, DataRecord dataRecord, String operation) {
        Expression expr = expression.getChildren()[0];
        dataRecord.setValue("operation", (Object)operation);
        dataRecord.setValue("column", (Object)((ColumnName)expr).getName());
        return dataRecord;
    }

    private static DataRecord makeColumnOperation(Expression expression, DataRecord dataRecord, String operation, Class<?> allowedOperand) {
        Expression leftExpression = expression.getChildren()[0];
        Expression rightExpression = expression.getChildren()[1];
        dataRecord.setValue("operation", (Object)operation);
        dataRecord.setValue("column", (Object)((ColumnName)leftExpression).getName());
        dataRecord.setValue("value", (Object)("'" + rightExpression.evaluate().toString() + "'"));
        return dataRecord;
    }
}

