/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter.converter;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.function.DefaultFunctions;
import com.tibbo.aggregate.common.filter.FilterApiConstants;
import com.tibbo.aggregate.common.filter.FunctionOperation;
import com.tibbo.aggregate.common.filter.converter.ControlStatesFilterUtil;
import com.tibbo.aggregate.common.filter.converter.FieldExpressionBuilder;
import com.tibbo.aggregate.common.filter.converter.StringFieldBuilder;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.logging.log4j.util.Strings;

public class ControlStatesFilterConverter {
    private static final long SECOND_IN_MS = 1000L;
    private static final long MINUTE_IN_MS = 60000L;
    private static final long HOUR_IN_MS = 3600000L;
    private static final long DAY_IN_MS = 86400000L;
    private static final long WEEK_IN_MS = 604800000L;
    private static final long MONTH_IN_MS = 2592000000L;
    private static final long QUARTER_IN_MS = 7862400000L;
    private static final long YEAR_IN_MS = 31536000000L;
    private static final Map<Character, BiFunction<DataTable, String, DataRecord>> typeHandlers = new HashMap<Character, BiFunction<DataTable, String, DataRecord>>();
    private static final Map<String, BiFunction<DataTable, String, DataRecord>> editorHandlers = new HashMap<String, BiFunction<DataTable, String, DataRecord>>();
    private static final Map<Integer, BiFunction<String, DataTable, String>> paneHandlers = new HashMap<Integer, BiFunction<String, DataTable, String>>();
    private static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    public static final String EQUALS = "==";
    public static final String NOT_EQUALS = "!=";
    public static final String GREATER = ">";
    public static final String GREATER_OR_EQUALS = ">=";
    public static final String LESS = "<";
    public static final String LESS_OR_EQUALS = "<=";

    public static DataTable buildEmptyStateTableFromMetadata(DataTable table) {
        SimpleDataTable result = new SimpleDataTable(FilterApiConstants.TF_COMPONENT_SMART_FILTER.clone());
        List<FieldFormat> fieldFormats = table.getFormat().getFields();
        for (FieldFormat ff : fieldFormats) {
            BiFunction<DataTable, String, DataRecord> func;
            BiFunction<DataTable, String, DataRecord> biFunction = func = ff.hasSelectionValues() ? typeHandlers.get(Character.valueOf('S')) : typeHandlers.get(Character.valueOf(ff.getType()));
            if (ff.isHidden()) continue;
            if (ff.getEditor() != null && editorHandlers.get(ff.getEditor()) != null) {
                func = editorHandlers.get(ff.getEditor());
            }
            if (func == null) {
                throw new IllegalStateException("");
            }
            func.apply(result, ff.getName());
        }
        return result;
    }

    public static String buildFilerTextExpression(DataTable dataTable) {
        Objects.requireNonNull(dataTable, "dataTable is null");
        if (dataTable.getRecordCount() == 0) {
            return "";
        }
        if (!dataTable.getFormat().equals(FilterApiConstants.TF_COMPONENT_SMART_FILTER)) {
            throw new IllegalArgumentException("Illegal smart filter format (DataTable)");
        }
        StringBuilder feb = new StringBuilder();
        for (int i = 0; i < dataTable.getRecordCount(); ++i) {
            String columnExpression = ControlStatesFilterConverter.buildFilterTextExpressionFromFilterRow(dataTable.getRecord(i));
            if (!columnExpression.isEmpty()) {
                FieldExpressionBuilder.withLogicalAnd(feb);
            }
            feb.append(columnExpression);
        }
        return feb.toString();
    }

    private static String buildFilterTextExpressionFromFilterRow(DataRecord filterRecord) {
        String columnName = filterRecord.getString("COMPONENT_SMART_FILTER_COLUMN");
        Integer smartFilterPaneType = filterRecord.getInt("COMPONENT_SMART_FILTER_TYPE");
        DataTable smartFilterPane = filterRecord.getDataTable("COMPONENT_SMART_FILTER_STATE");
        return paneHandlers.get(smartFilterPaneType).apply(columnName, smartFilterPane);
    }

    private static DataRecord integerConverter(DataTable dataTable, String columnName) {
        DataRecord columnFilter = dataTable.addRecord();
        SimpleDataTable paneTable = new SimpleDataTable(FilterApiConstants.TF_CONTROL_PANE_NUMERIC_VALUE);
        DataRecord paneRecord = paneTable.addRecord();
        paneRecord.setValue("PANE_FIELD_VALUE_PRESENCE", (Object)1);
        paneRecord.setValue("PANE_FIELD_EQUALS", (Object)ControlStatesFilterUtil.makeEmptyInteger());
        paneRecord.setValue("PANE_FIELD_INCLUDED_IN", (Object)ControlStatesFilterUtil.makeEmptyIntegerList());
        paneRecord.setValue("PANE_FIELD_DOES_NOT_EQUAL", (Object)ControlStatesFilterUtil.makeEmptyInteger());
        paneRecord.setValue("PANE_FIELD_GREATER_THAN", (Object)ControlStatesFilterUtil.makeEmptyInteger());
        paneRecord.setValue("PANE_FIELD_GREATER_OR_EQUAL_THAN", (Object)ControlStatesFilterUtil.makeEmptyInteger());
        paneRecord.setValue("PANE_FIELD_LESS_THAN", (Object)ControlStatesFilterUtil.makeEmptyInteger());
        paneRecord.setValue("PANE_FIELD_LESS_OR_EQUAL_THAN", (Object)ControlStatesFilterUtil.makeEmptyInteger());
        columnFilter.setValue("COMPONENT_SMART_FILTER_COLUMN", (Object)columnName);
        columnFilter.setValue("COMPONENT_SMART_FILTER_TYPE", (Object)1);
        columnFilter.setValue("COMPONENT_SMART_FILTER_STATE", (Object)paneTable);
        return columnFilter;
    }

    private static DataRecord stringConverter(DataTable dataTable, String columnName) {
        DataRecord columnFilter = dataTable.addRecord();
        SimpleDataTable paneTable = new SimpleDataTable(FilterApiConstants.TF_CONTROL_PANE_STRING_VALUE);
        DataRecord paneRecord = paneTable.addRecord();
        paneRecord.setValue("PANE_FIELD_VALUE_PRESENCE", (Object)1);
        paneRecord.setValue("PANE_FIELD_EQUALS", null);
        paneRecord.setValue("PANE_FIELD_INCLUDED_IN", (Object)ControlStatesFilterUtil.makeEmptyStringList());
        paneRecord.setValue("PANE_FIELD_DOES_NOT_EQUAL", null);
        paneRecord.setValue("PANE_FIELD_CONTAINS", null);
        paneRecord.setValue("PANE_FIELD_DOES_NOT_CONTAIN", null);
        paneRecord.setValue("PANE_FIELD_BEGINS_WITH", null);
        paneRecord.setValue("PANE_FIELD_DOES_NOT_BEGIN_WITH", null);
        paneRecord.setValue("PANE_FIELD_ENDS_WITH", null);
        paneRecord.setValue("PANE_FIELD_DOES_NOT_END_WITH", null);
        columnFilter.setValue("COMPONENT_SMART_FILTER_COLUMN", (Object)columnName);
        columnFilter.setValue("COMPONENT_SMART_FILTER_TYPE", (Object)2);
        columnFilter.setValue("COMPONENT_SMART_FILTER_STATE", (Object)paneTable);
        return columnFilter;
    }

    private static DataRecord booleanConverter(DataTable dataTable, String columnName) {
        DataRecord columnFilter = dataTable.addRecord();
        SimpleDataTable paneTable = new SimpleDataTable(FilterApiConstants.TF_CONTROL_PANE_BOOLEAN_VALUE);
        DataRecord paneRecord = paneTable.addRecord();
        paneRecord.setValue("PANE_FIELD_VALUE_PRESENCE", (Object)1);
        paneRecord.setValue("PANE_FIELD_EQUALS", (Object)1);
        columnFilter.setValue("COMPONENT_SMART_FILTER_COLUMN", (Object)columnName);
        columnFilter.setValue("COMPONENT_SMART_FILTER_TYPE", (Object)3);
        columnFilter.setValue("COMPONENT_SMART_FILTER_STATE", (Object)paneTable);
        return columnFilter;
    }

    private static DataRecord longConverter(DataTable dataTable, String columnName) {
        DataRecord columnFilter = dataTable.addRecord();
        SimpleDataTable paneTable = new SimpleDataTable(FilterApiConstants.TF_CONTROL_PANE_NUMERIC_VALUE);
        DataRecord paneRecord = paneTable.addRecord();
        paneRecord.setValue("PANE_FIELD_VALUE_PRESENCE", (Object)1);
        paneRecord.setValue("PANE_FIELD_EQUALS", (Object)ControlStatesFilterUtil.makeEmptyLong());
        paneRecord.setValue("PANE_FIELD_INCLUDED_IN", (Object)ControlStatesFilterUtil.makeEmptyLongList());
        paneRecord.setValue("PANE_FIELD_DOES_NOT_EQUAL", (Object)ControlStatesFilterUtil.makeEmptyLong());
        paneRecord.setValue("PANE_FIELD_GREATER_THAN", (Object)ControlStatesFilterUtil.makeEmptyLong());
        paneRecord.setValue("PANE_FIELD_GREATER_OR_EQUAL_THAN", (Object)ControlStatesFilterUtil.makeEmptyLong());
        paneRecord.setValue("PANE_FIELD_LESS_THAN", (Object)ControlStatesFilterUtil.makeEmptyLong());
        paneRecord.setValue("PANE_FIELD_LESS_OR_EQUAL_THAN", (Object)ControlStatesFilterUtil.makeEmptyLong());
        columnFilter.setValue("COMPONENT_SMART_FILTER_COLUMN", (Object)columnName);
        columnFilter.setValue("COMPONENT_SMART_FILTER_TYPE", (Object)1);
        columnFilter.setValue("COMPONENT_SMART_FILTER_STATE", (Object)paneTable);
        return columnFilter;
    }

    private static DataRecord floatConverter(DataTable dataTable, String columnName) {
        DataRecord columnFilter = dataTable.addRecord();
        SimpleDataTable paneTable = new SimpleDataTable(FilterApiConstants.TF_CONTROL_PANE_NUMERIC_VALUE);
        DataRecord paneRecord = paneTable.addRecord();
        paneRecord.setValue("PANE_FIELD_VALUE_PRESENCE", (Object)1);
        paneRecord.setValue("PANE_FIELD_EQUALS", (Object)ControlStatesFilterUtil.makeEmptyFloat());
        paneRecord.setValue("PANE_FIELD_INCLUDED_IN", (Object)ControlStatesFilterUtil.makeEmptyFloatList());
        paneRecord.setValue("PANE_FIELD_DOES_NOT_EQUAL", (Object)ControlStatesFilterUtil.makeEmptyFloat());
        paneRecord.setValue("PANE_FIELD_GREATER_THAN", (Object)ControlStatesFilterUtil.makeEmptyFloat());
        paneRecord.setValue("PANE_FIELD_GREATER_OR_EQUAL_THAN", (Object)ControlStatesFilterUtil.makeEmptyFloat());
        paneRecord.setValue("PANE_FIELD_LESS_THAN", (Object)ControlStatesFilterUtil.makeEmptyFloat());
        paneRecord.setValue("PANE_FIELD_LESS_OR_EQUAL_THAN", (Object)ControlStatesFilterUtil.makeEmptyFloat());
        columnFilter.setValue("COMPONENT_SMART_FILTER_COLUMN", (Object)columnName);
        columnFilter.setValue("COMPONENT_SMART_FILTER_TYPE", (Object)1);
        columnFilter.setValue("COMPONENT_SMART_FILTER_STATE", (Object)paneTable);
        return columnFilter;
    }

    private static DataRecord doubleConverter(DataTable dataTable, String columnName) {
        DataRecord columnFilter = dataTable.addRecord();
        SimpleDataTable paneTable = new SimpleDataTable(FilterApiConstants.TF_CONTROL_PANE_NUMERIC_VALUE);
        DataRecord paneRecord = paneTable.addRecord();
        paneRecord.setValue("PANE_FIELD_VALUE_PRESENCE", (Object)1);
        paneRecord.setValue("PANE_FIELD_EQUALS", (Object)ControlStatesFilterUtil.makeEmptyDouble());
        paneRecord.setValue("PANE_FIELD_INCLUDED_IN", (Object)ControlStatesFilterUtil.makeEmptyDoubleList());
        paneRecord.setValue("PANE_FIELD_DOES_NOT_EQUAL", (Object)ControlStatesFilterUtil.makeEmptyDouble());
        paneRecord.setValue("PANE_FIELD_GREATER_THAN", (Object)ControlStatesFilterUtil.makeEmptyDouble());
        paneRecord.setValue("PANE_FIELD_GREATER_OR_EQUAL_THAN", (Object)ControlStatesFilterUtil.makeEmptyDouble());
        paneRecord.setValue("PANE_FIELD_LESS_THAN", (Object)ControlStatesFilterUtil.makeEmptyDouble());
        paneRecord.setValue("PANE_FIELD_LESS_OR_EQUAL_THAN", (Object)ControlStatesFilterUtil.makeEmptyDouble());
        columnFilter.setValue("COMPONENT_SMART_FILTER_COLUMN", (Object)columnName);
        columnFilter.setValue("COMPONENT_SMART_FILTER_TYPE", (Object)1);
        columnFilter.setValue("COMPONENT_SMART_FILTER_STATE", (Object)paneTable);
        return columnFilter;
    }

    private static DataRecord timeConverter(DataTable dataTable, String columnName) {
        return ControlStatesFilterConverter.dateTimeConverter(dataTable, columnName, "time");
    }

    private static DataRecord dateConverter(DataTable dataTable, String columnName) {
        return ControlStatesFilterConverter.dateTimeConverter(dataTable, columnName, "date");
    }

    private static DataRecord dateTimeConverter(DataTable dataTable, String columnName) {
        return ControlStatesFilterConverter.dateTimeConverter(dataTable, columnName, null);
    }

    private static DataRecord dateTimeConverter(DataTable dataTable, String columnName, String editor) {
        DataRecord columnFilter = dataTable.addRecord();
        SimpleDataTable paneTable = new SimpleDataTable(FilterApiConstants.TF_CONTROL_PANE_DATE_VALUE);
        DataRecord paneRecord = paneTable.addRecord();
        paneRecord.setValue("PANE_FIELD_VALUE_PRESENCE", (Object)1);
        paneRecord.setValue("PANE_FIELD_EQUALS", null);
        paneRecord.setValue("PANE_FIELD_INCLUDED_IN", (Object)ControlStatesFilterUtil.makeEmptyDateList());
        paneRecord.setValue("PANE_FIELD_DOES_NOT_EQUAL", null);
        paneRecord.setValue("PANE_FIELD_GREATER_THAN", null);
        paneRecord.setValue("PANE_FIELD_GREATER_OR_EQUAL_THAN", null);
        paneRecord.setValue("PANE_FIELD_LESS_THAN", null);
        paneRecord.setValue("PANE_FIELD_LESS_OR_EQUAL_THAN", null);
        paneRecord.setValue("PANE_FIELD_LAST_INTERVAL", null);
        paneRecord.setValue("PANE_FIELD_CURRENT_INTERVAL", (Object)0);
        paneRecord.setValue("PANE_FIELD_NEXT_INTERVAL", null);
        paneRecord.setValue("PANE_FIELD_DATE_TIME_RANGE", (Object)ControlStatesFilterUtil.makeEmptyRange());
        paneRecord.setValue("PANE_FIELD_EDITOR", (Object)editor);
        columnFilter.setValue("COMPONENT_SMART_FILTER_COLUMN", (Object)columnName);
        columnFilter.setValue("COMPONENT_SMART_FILTER_TYPE", (Object)5);
        columnFilter.setValue("COMPONENT_SMART_FILTER_STATE", (Object)paneTable);
        return columnFilter;
    }

    private static DataRecord dataTableConverter(DataTable dataTable, String columnName) {
        DataRecord columnFilter = dataTable.addRecord();
        SimpleDataTable paneTable = new SimpleDataTable(FilterApiConstants.TF_CONTROL_PANE_DATATABLE_VALUE);
        DataRecord paneRecord = paneTable.addRecord();
        paneRecord.setValue("PANE_FIELD_VALUE_PRESENCE", (Object)1);
        paneRecord.setValue("PANE_FIELD_CONTAINS", null);
        paneRecord.setValue("PANE_FIELD_DOES_NOT_CONTAIN", null);
        paneRecord.setValue("PANE_FIELD_RECORD_COUNT", null);
        columnFilter.setValue("COMPONENT_SMART_FILTER_COLUMN", (Object)columnName);
        columnFilter.setValue("COMPONENT_SMART_FILTER_TYPE", (Object)6);
        columnFilter.setValue("COMPONENT_SMART_FILTER_STATE", (Object)paneTable);
        return columnFilter;
    }

    private static DataRecord colorConverter(DataTable dataTable, String columnName) {
        DataRecord columnFilter = dataTable.addRecord();
        SimpleDataTable paneTable = new SimpleDataTable(FilterApiConstants.TF_CONTROL_PANE_COLOR_VALUE);
        DataRecord paneRecord = paneTable.addRecord();
        paneRecord.setValue("PANE_FIELD_VALUE_PRESENCE", (Object)1);
        paneRecord.setValue("PANE_FIELD_EQUALS", null);
        paneRecord.setValue("PANE_FIELD_DOES_NOT_EQUAL", null);
        columnFilter.setValue("COMPONENT_SMART_FILTER_COLUMN", (Object)columnName);
        columnFilter.setValue("COMPONENT_SMART_FILTER_TYPE", (Object)4);
        columnFilter.setValue("COMPONENT_SMART_FILTER_STATE", (Object)paneTable);
        return columnFilter;
    }

    private static DataRecord dataConverter(DataTable dataTable, String columnName) {
        DataRecord columnFilter = dataTable.addRecord();
        SimpleDataTable paneTable = new SimpleDataTable(FilterApiConstants.TF_CONTROL_PANE_DATABLOCK_VALUE);
        DataRecord paneRecord = paneTable.addRecord();
        paneRecord.setValue("PANE_FIELD_VALUE_PRESENCE", (Object)1);
        paneRecord.setValue("PANE_FIELD_FILE_TYPE", null);
        columnFilter.setValue("COMPONENT_SMART_FILTER_COLUMN", (Object)columnName);
        columnFilter.setValue("COMPONENT_SMART_FILTER_TYPE", (Object)7);
        columnFilter.setValue("COMPONENT_SMART_FILTER_STATE", (Object)paneTable);
        return columnFilter;
    }

    private static String undefinedPaneHandler(String columnName, DataTable paneTable) {
        throw new IllegalArgumentException("Undefined pane type");
    }

    private static String numericPaneHandler(String columnName, DataTable paneTable) {
        if (paneTable == null || paneTable.getRecordCount() == 0) {
            return "";
        }
        if (!paneTable.getFormat().equals(FilterApiConstants.TF_CONTROL_PANE_NUMERIC_VALUE)) {
            throw new IllegalArgumentException("Illegal numeric pane table");
        }
        StringBuilder fb = new StringBuilder();
        FieldExpressionBuilder.expandValuePresence(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandNumericFieldEquals(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandNumericFieldIn(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandNumericFieldNotEqual(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandNumericGreaterThan(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandNumericGreaterOrEqualThan(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandNumericLessThan(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandNumericLessOrEqualThan(columnName, paneTable, fb);
        return fb.toString();
    }

    private static String stringPaneHandler(String columnName, DataTable paneTable) {
        if (paneTable == null || paneTable.getRecordCount() == 0) {
            return "";
        }
        StringFieldBuilder builder = new StringFieldBuilder();
        builder.withValuePresence(columnName, paneTable);
        builder.withStringFieldOperation(columnName, paneTable, "PANE_FIELD_EQUALS", EQUALS);
        builder.withStringFieldInOperation(columnName, paneTable);
        builder.withStringFieldOperation(columnName, paneTable, "PANE_FIELD_DOES_NOT_EQUAL", NOT_EQUALS);
        builder.withStringFieldFunction(columnName, paneTable, "PANE_FIELD_CONTAINS", FunctionOperation.FilterFunctions.CONTAINS.getName());
        builder.withStringFieldFunction(columnName, paneTable, "PANE_FIELD_DOES_NOT_CONTAIN", "!" + FunctionOperation.FilterFunctions.CONTAINS.getName());
        builder.withStringFieldFunction(columnName, paneTable, "PANE_FIELD_BEGINS_WITH", FunctionOperation.FilterFunctions.BEGINS_WITH.getName());
        builder.withStringFieldFunction(columnName, paneTable, "PANE_FIELD_DOES_NOT_BEGIN_WITH", "!" + FunctionOperation.FilterFunctions.BEGINS_WITH.getName());
        builder.withStringFieldFunction(columnName, paneTable, "PANE_FIELD_ENDS_WITH", FunctionOperation.FilterFunctions.END_WITH.getName());
        builder.withStringFieldFunction(columnName, paneTable, "PANE_FIELD_DOES_NOT_END_WITH", "!" + FunctionOperation.FilterFunctions.END_WITH.getName());
        return builder.build();
    }

    private static String booleanPaneHandler(String columnName, DataTable paneTable) {
        if (paneTable == null || paneTable.getRecordCount() == 0) {
            return "";
        }
        if (!paneTable.getFormat().equals(FilterApiConstants.TF_CONTROL_PANE_BOOLEAN_VALUE)) {
            throw new IllegalArgumentException("Illegal boolean pane table");
        }
        StringBuilder fb = new StringBuilder();
        FieldExpressionBuilder.expandValuePresence(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandBooleanFieldOperation(columnName, paneTable, fb, "PANE_FIELD_EQUALS", EQUALS);
        return fb.toString();
    }

    private static String colorPaneHandler(String columnName, DataTable paneTable) {
        if (paneTable == null || paneTable.getRecordCount() == 0) {
            return "";
        }
        if (!paneTable.getFormat().equals(FilterApiConstants.TF_CONTROL_PANE_COLOR_VALUE)) {
            throw new IllegalArgumentException("Illegal color pane table");
        }
        StringBuilder fb = new StringBuilder();
        FieldExpressionBuilder.expandValuePresence(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandColorFieldOperation(columnName, paneTable, fb, "PANE_FIELD_EQUALS", EQUALS);
        ControlStatesFilterConverter.expandColorFieldOperation(columnName, paneTable, fb, "PANE_FIELD_DOES_NOT_EQUAL", NOT_EQUALS);
        return fb.toString();
    }

    private static String datePaneHandler(String columnName, DataTable paneTable) {
        if (paneTable == null || paneTable.getRecordCount() == 0) {
            return "";
        }
        if (paneTable.getFormat().getFieldCount() != FilterApiConstants.TF_CONTROL_PANE_DATE_VALUE.getFieldCount()) {
            throw new IllegalArgumentException("Illegal date pane table");
        }
        StringBuilder fb = new StringBuilder();
        FieldExpressionBuilder.expandValuePresence(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandDateFieldOperation(columnName, paneTable, fb, "PANE_FIELD_EQUALS", EQUALS);
        ControlStatesFilterConverter.expandDateFieldInOperation(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandDateFieldOperation(columnName, paneTable, fb, "PANE_FIELD_DOES_NOT_EQUAL", NOT_EQUALS);
        ControlStatesFilterConverter.expandDateFieldOperation(columnName, paneTable, fb, "PANE_FIELD_GREATER_THAN", GREATER);
        ControlStatesFilterConverter.expandDateFieldOperation(columnName, paneTable, fb, "PANE_FIELD_GREATER_OR_EQUAL_THAN", GREATER_OR_EQUALS);
        ControlStatesFilterConverter.expandDateFieldOperation(columnName, paneTable, fb, "PANE_FIELD_LESS_THAN", LESS);
        ControlStatesFilterConverter.expandDateFieldOperation(columnName, paneTable, fb, "PANE_FIELD_LESS_OR_EQUAL_THAN", LESS_OR_EQUALS);
        ControlStatesFilterConverter.expandDateLastIntervalFieldOperation(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandDateCurrentIntervalFieldOperation(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandDateNextIntervalFieldOperation(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandDateRangeFieldOperation(columnName, paneTable, fb);
        return fb.toString();
    }

    private static String dataTablePaneHandler(String columnName, DataTable paneTable) {
        if (paneTable == null || paneTable.getRecordCount() == 0) {
            return "";
        }
        if (!paneTable.getFormat().equals(FilterApiConstants.TF_CONTROL_PANE_DATATABLE_VALUE)) {
            throw new IllegalArgumentException("Illegal dataTable pane table");
        }
        StringBuilder fb = new StringBuilder();
        FieldExpressionBuilder.expandValuePresence(columnName, paneTable, fb);
        ControlStatesFilterConverter.expandDataTableEncodedFieldOperation(columnName, paneTable, fb, "PANE_FIELD_CONTAINS", FunctionOperation.FilterFunctions.SIMPLE_CONTAINS.getName());
        ControlStatesFilterConverter.expandDataTableEncodedFieldOperation(columnName, paneTable, fb, "PANE_FIELD_DOES_NOT_CONTAIN", "!" + FunctionOperation.FilterFunctions.SIMPLE_CONTAINS.getName());
        ControlStatesFilterConverter.expandDataTableRecordsCountFieldOperation(columnName, paneTable, fb);
        return fb.toString();
    }

    private static String dataBlockPaneHandler(String columnName, DataTable paneTable) {
        return "";
    }

    private static void expandNumericFieldEquals(String columnName, DataTable paneTable, StringBuilder fb) {
        DataTable variant = paneTable.rec().getDataTable("PANE_FIELD_EQUALS");
        String strValue = ControlStatesFilterConverter.extractNumeric(variant);
        if (!strValue.isEmpty()) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapBinaryOperationColumn(fb, columnName, EQUALS, strValue);
        }
    }

    private static void expandNumericFieldIn(String columnName, DataTable paneTable, StringBuilder fb) {
        DataTable inValuesList = paneTable.rec().getDataTable("PANE_FIELD_INCLUDED_IN");
        String numericList = ControlStatesFilterConverter.extractNumerics(inValuesList);
        if (!numericList.isEmpty()) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapFunctionWithTwoParameters(fb, FunctionOperation.FilterFunctions.IN.getName(), columnName, numericList);
        }
    }

    private static void expandNumericFieldNotEqual(String columnName, DataTable paneTable, StringBuilder fb) {
        DataTable variant = paneTable.rec().getDataTable("PANE_FIELD_DOES_NOT_EQUAL");
        String strValue = ControlStatesFilterConverter.extractNumeric(variant);
        if (!strValue.isEmpty()) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapBinaryOperationColumn(fb, columnName, NOT_EQUALS, strValue);
        }
    }

    private static void expandNumericGreaterThan(String columnName, DataTable paneTable, StringBuilder fb) {
        DataTable variant = paneTable.rec().getDataTable("PANE_FIELD_GREATER_THAN");
        String strValue = ControlStatesFilterConverter.extractNumeric(variant);
        if (!strValue.isEmpty()) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapBinaryOperationColumn(fb, columnName, GREATER, strValue);
        }
    }

    private static void expandNumericGreaterOrEqualThan(String columnName, DataTable paneTable, StringBuilder fb) {
        DataTable variant = paneTable.rec().getDataTable("PANE_FIELD_GREATER_OR_EQUAL_THAN");
        String strValue = ControlStatesFilterConverter.extractNumeric(variant);
        if (!strValue.isEmpty()) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapBinaryOperationColumn(fb, columnName, GREATER_OR_EQUALS, strValue);
        }
    }

    private static void expandNumericLessThan(String columnName, DataTable paneTable, StringBuilder fb) {
        DataTable variant = paneTable.rec().getDataTable("PANE_FIELD_LESS_THAN");
        String strValue = ControlStatesFilterConverter.extractNumeric(variant);
        if (!strValue.isEmpty()) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapBinaryOperationColumn(fb, columnName, LESS, strValue);
        }
    }

    private static void expandNumericLessOrEqualThan(String columnName, DataTable paneTable, StringBuilder fb) {
        DataTable variant = paneTable.rec().getDataTable("PANE_FIELD_LESS_OR_EQUAL_THAN");
        String strValue = ControlStatesFilterConverter.extractNumeric(variant);
        if (!strValue.isEmpty()) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapBinaryOperationColumn(fb, columnName, LESS_OR_EQUALS, strValue);
        }
    }

    private static void expandBooleanFieldOperation(String columnName, DataTable paneTable, StringBuilder fb, String paneField, String opCode) {
        Integer value = paneTable.rec().getInt(paneField);
        if (value != null && value != 1) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapBinaryOperationColumn(fb, columnName, opCode, Boolean.valueOf(value == 3).toString());
        }
    }

    private static void expandColorFieldOperation(String columnName, DataTable paneTable, StringBuilder fb, String paneField, String opCode) {
        Color color = paneTable.rec().getColor(paneField);
        if (color != null) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapBinaryOperationColumn(fb, columnName, opCode, "color(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")");
        }
    }

    private static void expandDateFieldOperation(String columnName, DataTable paneTable, StringBuilder fb, String paneField, String opCode) {
        Date date = paneTable.rec().getDate(paneField);
        String editor = paneTable.rec().getString("PANE_FIELD_EDITOR");
        SimpleDateFormat simpleDateFormat = ControlStatesFilterConverter.getSimpleDateFormat(editor);
        ControlStatesFilterConverter.expandDateFieldOperation(columnName, fb, opCode, date, simpleDateFormat);
    }

    private static void expandDateFieldOperation(String columnName, StringBuilder fb, String opCode, Date date, SimpleDateFormat dateFormat) {
        if (date != null) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapBinaryOperationColumn(fb, columnName, opCode, "\"" + dateFormat.format(date) + "\"");
        }
    }

    private static void expandDateFieldInOperation(String columnName, DataTable paneTable, StringBuilder fb) {
        String editor;
        DataTable inValuesList = paneTable.rec().getDataTable("PANE_FIELD_INCLUDED_IN");
        String dateList = ControlStatesFilterConverter.extractDates(inValuesList, editor = paneTable.rec().getString("PANE_FIELD_EDITOR"));
        if (!dateList.isEmpty()) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapFunctionWithTwoParameters(fb, FunctionOperation.FilterFunctions.IN.getName(), columnName, dateList);
        }
    }

    private static void expandDateLastIntervalFieldOperation(String columnName, DataTable paneTable, StringBuilder fb) {
        ControlStatesFilterConverter.expandLongDateIntervalFieldOperation(columnName, paneTable, fb, false);
    }

    private static void expandDateNextIntervalFieldOperation(String columnName, DataTable paneTable, StringBuilder fb) {
        ControlStatesFilterConverter.expandLongDateIntervalFieldOperation(columnName, paneTable, fb, true);
    }

    private static void expandDateRangeFieldOperation(String columnName, DataTable paneTable, StringBuilder fb) {
        DataTable dateTimeRange = paneTable.rec().getDataTable("PANE_FIELD_DATE_TIME_RANGE");
        String editor = paneTable.rec().getString("PANE_FIELD_EDITOR");
        if (dateTimeRange != null && dateTimeRange.getRecordCount() != 0) {
            Date startDate = dateTimeRange.rec().getDate("startDate");
            Date endDate = dateTimeRange.rec().getDate("endDate");
            SimpleDateFormat simpleDateFormat = ControlStatesFilterConverter.getSimpleDateFormat(editor);
            ControlStatesFilterConverter.expandDateFieldOperation(columnName, fb, GREATER_OR_EQUALS, startDate, simpleDateFormat);
            ControlStatesFilterConverter.expandDateFieldOperation(columnName, fb, LESS_OR_EQUALS, endDate, simpleDateFormat);
        }
    }

    private static SimpleDateFormat getSimpleDateFormat(String editor) {
        SimpleDateFormat simpleDateFormat = dateTimeFormat;
        if (editor != null) {
            simpleDateFormat = editor.equals("date") ? dateFormat : timeFormat;
        }
        return simpleDateFormat;
    }

    private static void expandDateCurrentIntervalFieldOperation(String columnName, DataTable paneTable, StringBuilder fb) {
        Integer interval = paneTable.rec().getInt("PANE_FIELD_CURRENT_INTERVAL");
        if (interval != null) {
            String func;
            switch (interval) {
                case 0: {
                    return;
                }
                case 1: {
                    func = FunctionOperation.FilterFunctions.THIS_HOUR.getName();
                    break;
                }
                case 2: {
                    func = FunctionOperation.FilterFunctions.TODAY.getName();
                    break;
                }
                case 3: {
                    func = FunctionOperation.FilterFunctions.THIS_WEEK.getName();
                    break;
                }
                case 4: {
                    func = FunctionOperation.FilterFunctions.THIS_MONTH.getName();
                    break;
                }
                case 5: {
                    func = FunctionOperation.FilterFunctions.THIS_YEAR.getName();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal time interval");
                }
            }
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapSingleColumnArgument(fb, func, columnName);
        }
    }

    private static void expandDataTableEncodedFieldOperation(String columnName, DataTable paneTable, StringBuilder fb, String paneField, String funcName) {
        String strValue = paneTable.rec().getString(paneField);
        if (Strings.isNotBlank((String)strValue)) {
            strValue = strValue.replaceAll("\\\\", "\\\\\\\\");
            strValue = strValue.replaceAll("'", "\\\\'");
            strValue = strValue.replaceAll("\"", "\\\\\"");
            StringBuilder sb = new StringBuilder();
            FieldExpressionBuilder.wrapFunctionWithTwoParameters(sb, DefaultFunctions.ENCODE.getName(), columnName, Boolean.TRUE.toString());
            FieldExpressionBuilder.wrapFunctionWithTwoParametersNotBraced(fb, funcName, sb.toString(), "\"" + strValue + "\"");
        }
    }

    private static void expandDataTableRecordsCountFieldOperation(String columnName, DataTable paneTable, StringBuilder fb) {
        Integer recordsCount = paneTable.rec().getInt("PANE_FIELD_RECORD_COUNT");
        if (recordsCount != null) {
            FieldExpressionBuilder.withLogicalAnd(fb);
            StringBuilder sb = new StringBuilder();
            FieldExpressionBuilder.wrapSingleColumnArgument(sb, DefaultFunctions.RECORDS.getName(), columnName);
            fb.append((CharSequence)sb).append(" == ").append(recordsCount);
        }
    }

    private static void expandLongDateIntervalFieldOperation(String columnName, DataTable paneTable, StringBuilder fb, boolean lastNext) {
        Long longInterval = paneTable.rec().getLong(lastNext ? "PANE_FIELD_NEXT_INTERVAL" : "PANE_FIELD_LAST_INTERVAL");
        if (longInterval != null) {
            String func;
            long amount = longInterval / 31536000000L;
            if (amount >= 1L && longInterval % 31536000000L == 0L) {
                func = lastNext ? FunctionOperation.FilterFunctions.NEXT_X_YEARS.getName() : FunctionOperation.FilterFunctions.LAST_X_YEARS.getName();
            } else {
                amount = longInterval / 2592000000L;
                if (amount >= 1L && longInterval % 2592000000L == 0L) {
                    func = lastNext ? FunctionOperation.FilterFunctions.NEXT_X_MONTHS.getName() : FunctionOperation.FilterFunctions.LAST_X_MONTHS.getName();
                } else {
                    amount = longInterval / 604800000L;
                    if (amount >= 1L && longInterval % 604800000L == 0L) {
                        func = lastNext ? FunctionOperation.FilterFunctions.NEXT_X_WEEKS.getName() : FunctionOperation.FilterFunctions.LAST_X_WEEKS.getName();
                    } else {
                        amount = longInterval / 86400000L;
                        if (amount >= 1L && longInterval % 86400000L == 0L) {
                            func = lastNext ? FunctionOperation.FilterFunctions.NEXT_X_DAYS.getName() : FunctionOperation.FilterFunctions.LAST_X_DAYS.getName();
                        } else {
                            amount = longInterval / 3600000L;
                            func = lastNext ? FunctionOperation.FilterFunctions.NEXT_X_HOURS.getName() : FunctionOperation.FilterFunctions.LAST_X_HOURS.getName();
                        }
                    }
                }
            }
            FieldExpressionBuilder.withLogicalAnd(fb);
            FieldExpressionBuilder.wrapFunctionWithTwoParameters(fb, func, columnName, "" + amount);
        }
    }

    private static String extractNumeric(DataTable variant) {
        if (variant == null || variant.getRecordCount() == 0) {
            return "";
        }
        if (variant.getFieldCount() != 1) {
            throw new IllegalArgumentException("Illegal table format. 1x1 numeric table is expected");
        }
        Object value = variant.rec().getValue(0);
        if (value == null) {
            return "";
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Illegal value type. Numeric is expected");
        }
        return value.toString();
    }

    private static String extractNumerics(DataTable inValues) {
        if (inValues == null || inValues.getRecordCount() == 0) {
            return "";
        }
        if (inValues.getFieldCount() != 1) {
            throw new IllegalArgumentException("Illegal table format. nx1 numeric table is expected");
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < inValues.getRecordCount(); ++i) {
            Object value = inValues.getRecord(i).getValue(0);
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException("Illegal value type. Numeric is expected");
            }
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(value);
        }
        return sb.toString();
    }

    private static String extractDates(DataTable inValuesList, String editor) {
        if (inValuesList == null || inValuesList.getRecordCount() == 0) {
            return "";
        }
        if (inValuesList.getFieldCount() != 1) {
            throw new IllegalArgumentException("Illegal table format. nx1 date table is expected");
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < inValuesList.getRecordCount(); ++i) {
            Object value = inValuesList.getRecord(i).getValue(0);
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("Illegal value type. Date is expected");
            }
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append('\"');
            sb.append(ControlStatesFilterConverter.getSimpleDateFormat(editor).format((Date)value));
            sb.append('\"');
        }
        return sb.toString();
    }

    static {
        typeHandlers.put(Character.valueOf('I'), ControlStatesFilterConverter::integerConverter);
        typeHandlers.put(Character.valueOf('S'), ControlStatesFilterConverter::stringConverter);
        typeHandlers.put(Character.valueOf('B'), ControlStatesFilterConverter::booleanConverter);
        typeHandlers.put(Character.valueOf('L'), ControlStatesFilterConverter::longConverter);
        typeHandlers.put(Character.valueOf('F'), ControlStatesFilterConverter::floatConverter);
        typeHandlers.put(Character.valueOf('E'), ControlStatesFilterConverter::doubleConverter);
        typeHandlers.put(Character.valueOf('D'), ControlStatesFilterConverter::dateTimeConverter);
        typeHandlers.put(Character.valueOf('T'), ControlStatesFilterConverter::dataTableConverter);
        typeHandlers.put(Character.valueOf('C'), ControlStatesFilterConverter::colorConverter);
        typeHandlers.put(Character.valueOf('A'), ControlStatesFilterConverter::dataConverter);
        editorHandlers.put("instance", ControlStatesFilterConverter::stringConverter);
        editorHandlers.put("foreignInstance", ControlStatesFilterConverter::stringConverter);
        editorHandlers.put("date", ControlStatesFilterConverter::dateConverter);
        editorHandlers.put("time", ControlStatesFilterConverter::timeConverter);
        paneHandlers.put(0, ControlStatesFilterConverter::undefinedPaneHandler);
        paneHandlers.put(1, ControlStatesFilterConverter::numericPaneHandler);
        paneHandlers.put(2, ControlStatesFilterConverter::stringPaneHandler);
        paneHandlers.put(3, ControlStatesFilterConverter::booleanPaneHandler);
        paneHandlers.put(4, ControlStatesFilterConverter::colorPaneHandler);
        paneHandlers.put(5, ControlStatesFilterConverter::datePaneHandler);
        paneHandlers.put(6, ControlStatesFilterConverter::dataTablePaneHandler);
        paneHandlers.put(7, ControlStatesFilterConverter::dataBlockPaneHandler);
    }

    private static class ExtraStringDataHandler
    implements BiFunction<DataTable, String, DataRecord> {
        private Map<String, DataTable> extraData;

        public ExtraStringDataHandler(Map<String, DataTable> extraData) {
            this.extraData = extraData;
        }

        @Override
        public DataRecord apply(DataTable dataTable, String columnName) {
            DataRecord columnFilter = dataTable.addRecord();
            TableFormat tf = FilterApiConstants.TF_CONTROL_PANE_STRING_VALUE.clone();
            if (this.extraData.containsKey(columnName)) {
                FieldFormat equalsField = tf.getField("PANE_FIELD_EQUALS");
                FieldFormat notEqualField = tf.getField("PANE_FIELD_DOES_NOT_EQUAL");
                DataTable values = this.extraData.get(columnName);
                for (int i = 0; i < values.getRecordCount(); ++i) {
                    DataRecord dr = values.getRecord(i);
                    if (!(dr.getValue(0) instanceof String) || ((String)dr.getValue(0)).isEmpty()) continue;
                    equalsField.addSelectionValue(dr.getValue(0));
                    notEqualField.addSelectionValue(dr.getValue(0));
                }
            }
            SimpleDataTable paneTable = new SimpleDataTable(tf);
            DataRecord paneRecord = paneTable.addRecord();
            paneRecord.setValue("PANE_FIELD_VALUE_PRESENCE", (Object)1);
            paneRecord.setValue("PANE_FIELD_EQUALS", null);
            paneRecord.setValue("PANE_FIELD_INCLUDED_IN", (Object)ControlStatesFilterUtil.makeEmptyStringList());
            paneRecord.setValue("PANE_FIELD_DOES_NOT_EQUAL", null);
            paneRecord.setValue("PANE_FIELD_CONTAINS", null);
            paneRecord.setValue("PANE_FIELD_DOES_NOT_CONTAIN", null);
            paneRecord.setValue("PANE_FIELD_BEGINS_WITH", null);
            paneRecord.setValue("PANE_FIELD_DOES_NOT_BEGIN_WITH", null);
            paneRecord.setValue("PANE_FIELD_ENDS_WITH", null);
            paneRecord.setValue("PANE_FIELD_DOES_NOT_END_WITH", null);
            columnFilter.setValue("COMPONENT_SMART_FILTER_COLUMN", (Object)columnName);
            columnFilter.setValue("COMPONENT_SMART_FILTER_TYPE", (Object)2);
            columnFilter.setValue("COMPONENT_SMART_FILTER_STATE", (Object)paneTable);
            return columnFilter;
        }
    }
}

