/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter.converter;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.filter.AbstractBooleanBinaryOperation;
import com.tibbo.aggregate.common.filter.BeginWithFunctionOperation;
import com.tibbo.aggregate.common.filter.ContainsFunctionOperation;
import com.tibbo.aggregate.common.filter.DoesNotEqualOperation;
import com.tibbo.aggregate.common.filter.EndsWithFunctionOperation;
import com.tibbo.aggregate.common.filter.EqualsOperation;
import com.tibbo.aggregate.common.filter.Expression;
import com.tibbo.aggregate.common.filter.GreaterOrEqualThanOperation;
import com.tibbo.aggregate.common.filter.GreaterThanOperation;
import com.tibbo.aggregate.common.filter.InFunctionOperation;
import com.tibbo.aggregate.common.filter.IsNotNullFunctionOperation;
import com.tibbo.aggregate.common.filter.IsNullFunctionOperation;
import com.tibbo.aggregate.common.filter.LastDaysFunctionOperation;
import com.tibbo.aggregate.common.filter.LastHoursFunctionOperation;
import com.tibbo.aggregate.common.filter.LastMonthsFunctionOperation;
import com.tibbo.aggregate.common.filter.LastWeeksFunctionOperation;
import com.tibbo.aggregate.common.filter.LastYearsFunctionOperation;
import com.tibbo.aggregate.common.filter.LessOrEqualThanOperation;
import com.tibbo.aggregate.common.filter.LessThanOperation;
import com.tibbo.aggregate.common.filter.LogicalAndOperation;
import com.tibbo.aggregate.common.filter.LogicalNotOperation;
import com.tibbo.aggregate.common.filter.LogicalOrOperation;
import com.tibbo.aggregate.common.filter.NextDaysFunctionOperation;
import com.tibbo.aggregate.common.filter.NextHoursFunctionOperation;
import com.tibbo.aggregate.common.filter.NextMonthsFunctionOperation;
import com.tibbo.aggregate.common.filter.NextWeeksFunctionOperation;
import com.tibbo.aggregate.common.filter.NextYearsFunctionOperation;
import com.tibbo.aggregate.common.filter.OnAfterFunctionOperation;
import com.tibbo.aggregate.common.filter.OnBeforeFunctionOperation;
import com.tibbo.aggregate.common.filter.OnFunctionOperation;
import com.tibbo.aggregate.common.filter.ThisHourFunctionOperation;
import com.tibbo.aggregate.common.filter.ThisMonthFunctionOperation;
import com.tibbo.aggregate.common.filter.ThisWeekFunctionOperation;
import com.tibbo.aggregate.common.filter.ThisYearFunctionOperation;
import com.tibbo.aggregate.common.filter.TodayFunctionOperation;
import com.tibbo.aggregate.common.filter.TomorrowFunctionOperation;
import com.tibbo.aggregate.common.filter.YesterdayFunctionOperation;
import com.tibbo.aggregate.common.filter.converter.BinaryExpressionConverter;
import com.tibbo.aggregate.common.filter.converter.ConversionException;
import com.tibbo.aggregate.common.filter.converter.FunctionConverters;
import com.tibbo.aggregate.common.view.ViewFilterElement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public class ClassDteFilterConverter {
    private static final Map<Class<? extends Expression>, BiFunction<Expression, DataRecord, DataRecord>> operationConverters = new HashMap<Class<? extends Expression>, BiFunction<Expression, DataRecord, DataRecord>>();
    private static final Map<String, BiFunction<Expression, DataRecord, DataRecord>> functionConverters = new HashMap<String, BiFunction<Expression, DataRecord, DataRecord>>();
    private static final Set<Class<? extends Expression>> logicalNotOperationAllowedSubexpressions = new HashSet<Class<? extends Expression>>();

    public static DataTable convertExpressionToClassFilter(Expression filterExpression) {
        TableFormat fmt = ViewFilterElement.FORMAT.clone();
        SimpleDataTable res = new SimpleDataTable(fmt);
        ClassDteFilterConverter.expand(res, filterExpression, false);
        return res;
    }

    public static Expression convertClassFilterToExpression(DataTable classFilter) {
        return null;
    }

    private static void expand(DataTable res, Expression expression, boolean makeSubexpression) {
        if (expression instanceof AbstractBooleanBinaryOperation) {
            AbstractBooleanBinaryOperation booleanOperation = (AbstractBooleanBinaryOperation)expression;
            if (makeSubexpression) {
                DataRecord rec = res.getRecordCount() > 0 ? res.getRecord(res.getRecordCount() - 1) : res.addRecord();
                SimpleDataTable subExpression = new SimpleDataTable(ViewFilterElement.FORMAT.clone());
                ClassDteFilterConverter.expandBoolean(subExpression, booleanOperation);
                rec.setValue("type", (Object)1);
                rec.setValue("nested", (Object)subExpression);
            } else {
                ClassDteFilterConverter.expandBoolean(res, booleanOperation);
            }
        } else if (expression instanceof LogicalNotOperation) {
            LogicalNotOperation logicalNotOperation = (LogicalNotOperation)expression;
            ClassDteFilterConverter.validateNotOperationAvailabilityForExpression(logicalNotOperation.getChildren()[0]);
            ClassDteFilterConverter.expand(res, logicalNotOperation.getChildren()[0], makeSubexpression);
            ClassDteFilterConverter.applyLogicalInversion(res);
        } else {
            DataRecord rec = res.getRecordCount() > 0 ? res.getRecord(res.getRecordCount() - 1) : res.addRecord();
            rec.setValue("type", (Object)0);
            BiFunction<Expression, DataRecord, DataRecord> ec = operationConverters.get(expression.getClass());
            ec.apply(expression, rec);
        }
    }

    private static void applyLogicalInversion(DataTable res) {
        String operation;
        assert (res.getRecordCount() > 0);
        DataRecord rec = res.getRecord(res.getRecordCount() - 1);
        switch (operation = rec.getString("operation")) {
            case "BEGINS_WITH": {
                rec.setValue("operation", (Object)"DOES_NOT_BEGIN_WITH");
                break;
            }
            case "DOES_NOT_BEGIN_WITH": {
                rec.setValue("operation", (Object)"BEGINS_WITH");
                break;
            }
            case "ENDS_WITH": {
                rec.setValue("operation", (Object)"DOES_NOT_END_WITH");
                break;
            }
            case "DOES_NOT_END_WITH": {
                rec.setValue("operation", (Object)"ENDS_WITH");
                break;
            }
            case "CONTAINS": {
                rec.setValue("operation", (Object)"DOES_NOT_CONTAIN");
                break;
            }
            case "DOES_NOT_CONTAIN": {
                rec.setValue("operation", (Object)"CONTAINS");
            }
        }
    }

    private static void validateNotOperationAvailabilityForExpression(Expression expression) {
        if (!logicalNotOperationAllowedSubexpressions.contains(expression.getClass())) {
            throw new ConversionException(Cres.get().getString("smartFilterLogicalNotOperationNotSupportedFor") + ": " + expression.getDescription());
        }
    }

    private static void expandBoolean(DataTable res, AbstractBooleanBinaryOperation operation) {
        Expression left = operation.getChildren()[0];
        Expression right = operation.getChildren()[1];
        ClassDteFilterConverter.expand(res, left, operation.getPriority() > left.getPriority());
        assert (res.getRecordCount() > 0);
        DataRecord rec = res.addRecord();
        rec.setValue("logical", (Object)ClassDteFilterConverter.getBooleanOperationCode(operation));
        rec.setValue("type", (Object)0);
        ClassDteFilterConverter.expand(res, right, operation.getPriority() >= right.getPriority());
    }

    private static int getBooleanOperationCode(AbstractBooleanBinaryOperation operation) {
        if (operation instanceof LogicalAndOperation) {
            return 1;
        }
        if (operation instanceof LogicalOrOperation) {
            return 2;
        }
        throw new IllegalStateException("Illegal boolean operation");
    }

    static {
        logicalNotOperationAllowedSubexpressions.add(LogicalNotOperation.class);
        logicalNotOperationAllowedSubexpressions.add(BeginWithFunctionOperation.class);
        logicalNotOperationAllowedSubexpressions.add(EndsWithFunctionOperation.class);
        logicalNotOperationAllowedSubexpressions.add(ContainsFunctionOperation.class);
        logicalNotOperationAllowedSubexpressions.add(EqualsOperation.class);
        logicalNotOperationAllowedSubexpressions.add(DoesNotEqualOperation.class);
        logicalNotOperationAllowedSubexpressions.add(LessThanOperation.class);
        logicalNotOperationAllowedSubexpressions.add(LessOrEqualThanOperation.class);
        logicalNotOperationAllowedSubexpressions.add(GreaterThanOperation.class);
        logicalNotOperationAllowedSubexpressions.add(GreaterOrEqualThanOperation.class);
        operationConverters.put(EqualsOperation.class, BinaryExpressionConverter.create("EQUALS", Number.class, Boolean.class, String.class, Date.class));
        operationConverters.put(DoesNotEqualOperation.class, BinaryExpressionConverter.create("DOES_NOT_EQUAL", Number.class, Boolean.class, String.class, Date.class));
        operationConverters.put(GreaterThanOperation.class, BinaryExpressionConverter.create("IS_GREATER_THAN", Number.class, Boolean.class, String.class, Date.class));
        operationConverters.put(GreaterOrEqualThanOperation.class, BinaryExpressionConverter.create("IS_GREATER_OR_EQUAL_THAN", Number.class, Boolean.class, String.class, Date.class));
        operationConverters.put(LessThanOperation.class, BinaryExpressionConverter.create("IS_LESS_THAN", Number.class, Boolean.class, String.class, Date.class));
        operationConverters.put(LessOrEqualThanOperation.class, BinaryExpressionConverter.create("IS_LESS_OR_EQUAL_THAN", Number.class, Boolean.class, String.class, Date.class));
        operationConverters.put(ContainsFunctionOperation.class, FunctionConverters::contains);
        operationConverters.put(BeginWithFunctionOperation.class, FunctionConverters::startWith);
        operationConverters.put(EndsWithFunctionOperation.class, FunctionConverters::endsWith);
        operationConverters.put(OnAfterFunctionOperation.class, FunctionConverters::onAfter);
        operationConverters.put(OnBeforeFunctionOperation.class, FunctionConverters::onBefore);
        operationConverters.put(OnFunctionOperation.class, FunctionConverters::on);
        operationConverters.put(ThisHourFunctionOperation.class, FunctionConverters::thisHour);
        operationConverters.put(YesterdayFunctionOperation.class, FunctionConverters::yesterday);
        operationConverters.put(TodayFunctionOperation.class, FunctionConverters::today);
        operationConverters.put(TomorrowFunctionOperation.class, FunctionConverters::tomorrow);
        operationConverters.put(ThisWeekFunctionOperation.class, FunctionConverters::thisWeek);
        operationConverters.put(ThisMonthFunctionOperation.class, FunctionConverters::thisMonth);
        operationConverters.put(ThisYearFunctionOperation.class, FunctionConverters::thisYear);
        operationConverters.put(LastHoursFunctionOperation.class, FunctionConverters::lastHours);
        operationConverters.put(NextHoursFunctionOperation.class, FunctionConverters::nextHours);
        operationConverters.put(LastDaysFunctionOperation.class, FunctionConverters::lastDays);
        operationConverters.put(NextDaysFunctionOperation.class, FunctionConverters::nextDays);
        operationConverters.put(LastWeeksFunctionOperation.class, FunctionConverters::lastWeeks);
        operationConverters.put(NextWeeksFunctionOperation.class, FunctionConverters::nextWeeks);
        operationConverters.put(LastMonthsFunctionOperation.class, FunctionConverters::lastMonths);
        operationConverters.put(NextMonthsFunctionOperation.class, FunctionConverters::nextMonths);
        operationConverters.put(LastYearsFunctionOperation.class, FunctionConverters::lastYears);
        operationConverters.put(NextYearsFunctionOperation.class, FunctionConverters::nextYears);
        operationConverters.put(IsNullFunctionOperation.class, FunctionConverters::isNull);
        operationConverters.put(IsNotNullFunctionOperation.class, FunctionConverters::isNotNull);
        operationConverters.put(InFunctionOperation.class, FunctionConverters::includedIn);
    }
}

