/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter.converter;

public class BaseExpressionBuilder {
    protected final StringBuilder builder = new StringBuilder();

    public BaseExpressionBuilder withLogicalOr() {
        BaseExpressionBuilder.withLogicalOr(this.builder);
        return this;
    }

    public BaseExpressionBuilder withLogicalAnd() {
        BaseExpressionBuilder.withLogicalAnd(this.builder);
        return this;
    }

    public BaseExpressionBuilder withExpressionByAnd(String expression) {
        if (expression.isEmpty()) {
            return this;
        }
        this.withLogicalAnd();
        this.builder.append(this.wrap(expression));
        return this;
    }

    private String wrap(String expression) {
        return "(" + expression + ")";
    }

    public BaseExpressionBuilder withExpressionByOr(String expression) {
        if (expression.isEmpty()) {
            return this;
        }
        this.withLogicalOr();
        this.builder.append(this.wrap(expression));
        return this;
    }

    public static void withLogicalAnd(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(" && ");
        }
    }

    public static void withLogicalOr(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(" || ");
        }
    }

    public String build() {
        return this.builder.toString();
    }
}

