/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter.combiner;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.filter.FilterApiConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class ControlStatesFilterCombiner {
    private final DataTable baseFilterTable;
    private final Map<String, Integer> columnNameToPaneType = new HashMap<String, Integer>();
    private final Map<String, DataTable> columnNameToPaneTable = new HashMap<String, DataTable>();
    private static final Map<Integer, BiFunction<DataTable, DataTable, DataTable>> paneCombiner = new HashMap<Integer, BiFunction<DataTable, DataTable, DataTable>>();

    public ControlStatesFilterCombiner(DataTable baseFilterTable) {
        ControlStatesFilterCombiner.validateTableFormat(baseFilterTable);
        this.baseFilterTable = baseFilterTable.clone();
        baseFilterTable.stream().forEach(dr -> {
            this.columnNameToPaneType.put(dr.getString("COMPONENT_SMART_FILTER_COLUMN"), dr.getInt("COMPONENT_SMART_FILTER_TYPE"));
            this.columnNameToPaneTable.put(dr.getString("COMPONENT_SMART_FILTER_COLUMN"), dr.getDataTable("COMPONENT_SMART_FILTER_STATE"));
        });
    }

    public DataTable combine(DataTable filerTable) {
        ControlStatesFilterCombiner.validateTableFormat(filerTable);
        DataTable clonedBaseFilterTable = this.baseFilterTable.clone();
        for (int i = 0; i < filerTable.getRecordCount(); ++i) {
            DataRecord columnFilter = filerTable.getRecord(i);
            String columnName = columnFilter.getString("COMPONENT_SMART_FILTER_COLUMN");
            if (!this.columnNameToPaneType.containsKey(columnName)) {
                throw new IllegalArgumentException("Illegal column name: " + columnName);
            }
            Integer paneType = columnFilter.getInt("COMPONENT_SMART_FILTER_TYPE");
            if (!this.columnNameToPaneType.get(columnName).equals(paneType)) {
                throw new IllegalArgumentException("Pane type does not match for column: " + columnName);
            }
            DataTable fromPane = columnFilter.getDataTable("COMPONENT_SMART_FILTER_STATE");
            BiFunction<DataTable, DataTable, DataTable> combiner = paneCombiner.get(paneType);
            if (combiner == null) {
                throw new IllegalArgumentException("Illegal pane type");
            }
            DataTable intoPane = ControlStatesFilterCombiner.getPaneReference(columnName, clonedBaseFilterTable);
            combiner.apply(intoPane, fromPane);
        }
        return clonedBaseFilterTable;
    }

    private static DataTable getPaneReference(String columnName, DataTable filterTable) {
        ControlStatesFilterCombiner.validateTableFormat(filterTable);
        for (int i = 0; i < filterTable.getRecordCount(); ++i) {
            if (!columnName.equals(filterTable.getRecord(i).getString("COMPONENT_SMART_FILTER_COLUMN"))) continue;
            return filterTable.getRecord(i).getDataTable("COMPONENT_SMART_FILTER_STATE");
        }
        return null;
    }

    private static void validateTableFormat(DataTable filterTable) {
        if (!FilterApiConstants.TF_COMPONENT_SMART_FILTER.equals(filterTable.getFormat())) {
            throw new IllegalArgumentException("Illegal filter table format");
        }
    }

    private static DataTable numericPaneCombiner(DataTable into, DataTable from) {
        if (!FilterApiConstants.TF_CONTROL_PANE_NUMERIC_VALUE.equals(from.getFormat())) {
            throw new IllegalArgumentException("Illegal pane table format. Numeric pane is expected");
        }
        if (from.hasField("PANE_FIELD_VALUE_PRESENCE")) {
            into.rec().setValue("PANE_FIELD_VALUE_PRESENCE", from.rec().getValue("PANE_FIELD_VALUE_PRESENCE"));
        }
        if (from.hasField("PANE_FIELD_EQUALS")) {
            ControlStatesFilterCombiner.copyVariant(into.rec().getDataTable("PANE_FIELD_EQUALS"), from.rec().getDataTable("PANE_FIELD_EQUALS"));
        }
        if (from.hasField("PANE_FIELD_INCLUDED_IN")) {
            ControlStatesFilterCombiner.copyVector(into.rec().getDataTable("PANE_FIELD_INCLUDED_IN"), from.rec().getDataTable("PANE_FIELD_INCLUDED_IN"));
        }
        if (from.hasField("PANE_FIELD_DOES_NOT_EQUAL")) {
            ControlStatesFilterCombiner.copyVariant(into.rec().getDataTable("PANE_FIELD_DOES_NOT_EQUAL"), from.rec().getDataTable("PANE_FIELD_DOES_NOT_EQUAL"));
        }
        if (from.hasField("PANE_FIELD_GREATER_THAN")) {
            ControlStatesFilterCombiner.copyVariant(into.rec().getDataTable("PANE_FIELD_GREATER_THAN"), from.rec().getDataTable("PANE_FIELD_GREATER_THAN"));
        }
        if (from.hasField("PANE_FIELD_GREATER_OR_EQUAL_THAN")) {
            ControlStatesFilterCombiner.copyVariant(into.rec().getDataTable("PANE_FIELD_GREATER_OR_EQUAL_THAN"), from.rec().getDataTable("PANE_FIELD_GREATER_OR_EQUAL_THAN"));
        }
        if (from.hasField("PANE_FIELD_LESS_THAN")) {
            ControlStatesFilterCombiner.copyVariant(into.rec().getDataTable("PANE_FIELD_LESS_THAN"), from.rec().getDataTable("PANE_FIELD_LESS_THAN"));
        }
        if (from.hasField("PANE_FIELD_LESS_OR_EQUAL_THAN")) {
            ControlStatesFilterCombiner.copyVariant(into.rec().getDataTable("PANE_FIELD_LESS_OR_EQUAL_THAN"), from.rec().getDataTable("PANE_FIELD_LESS_OR_EQUAL_THAN"));
        }
        return into;
    }

    private static DataTable stringPaneCombiner(DataTable into, DataTable from) {
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_VALUE_PRESENCE");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_EQUALS");
        ControlStatesFilterCombiner.checkAndCopyControlStateVector(into, from, "PANE_FIELD_INCLUDED_IN");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_DOES_NOT_EQUAL");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_CONTAINS");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_DOES_NOT_CONTAIN");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_BEGINS_WITH");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_DOES_NOT_BEGIN_WITH");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_ENDS_WITH");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_DOES_NOT_END_WITH");
        return into;
    }

    private static DataTable booleanPaneCombiner(DataTable into, DataTable from) {
        if (!FilterApiConstants.TF_CONTROL_PANE_BOOLEAN_VALUE.equals(from.getFormat())) {
            throw new IllegalArgumentException("Illegal pane table format. Boolean pane is expected");
        }
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_VALUE_PRESENCE");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_EQUALS");
        return into;
    }

    private static DataTable colorPaneCombiner(DataTable into, DataTable from) {
        if (!FilterApiConstants.TF_CONTROL_PANE_COLOR_VALUE.equals(from.getFormat())) {
            throw new IllegalArgumentException("Illegal pane table format. Color pane is expected");
        }
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_VALUE_PRESENCE");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_EQUALS");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_DOES_NOT_EQUAL");
        return into;
    }

    private static DataTable datePaneCombiner(DataTable into, DataTable from) {
        if (!FilterApiConstants.TF_CONTROL_PANE_DATE_VALUE.equals(from.getFormat())) {
            throw new IllegalArgumentException("Illegal pane table format. Date pane is expected");
        }
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_VALUE_PRESENCE");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_EQUALS");
        ControlStatesFilterCombiner.checkAndCopyControlStateVector(into, from, "PANE_FIELD_INCLUDED_IN");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_DOES_NOT_EQUAL");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_GREATER_THAN");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_GREATER_OR_EQUAL_THAN");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_LESS_THAN");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_LESS_OR_EQUAL_THAN");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_LAST_INTERVAL");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_DATE_TIME_RANGE");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_CURRENT_INTERVAL");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_NEXT_INTERVAL");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_NEXT_INTERVAL");
        return into;
    }

    private static DataTable dataTablePaneCombiner(DataTable into, DataTable from) {
        if (!FilterApiConstants.TF_CONTROL_PANE_DATATABLE_VALUE.equals(from.getFormat())) {
            throw new IllegalArgumentException("Illegal pane table format. Data table pane is expected");
        }
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_VALUE_PRESENCE");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_CONTAINS");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_DOES_NOT_CONTAIN");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_RECORD_COUNT");
        return into;
    }

    private static DataTable dataBlockPaneCombiner(DataTable into, DataTable from) {
        if (!FilterApiConstants.TF_CONTROL_PANE_DATABLOCK_VALUE.equals(from.getFormat())) {
            throw new IllegalArgumentException("Illegal pane table format. Data block pane is expected");
        }
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_VALUE_PRESENCE");
        ControlStatesFilterCombiner.checkAndCopyControlStateValue(into, from, "PANE_FIELD_FILE_TYPE");
        return into;
    }

    private static void checkAndCopyControlStateValue(DataTable into, DataTable from, String control) {
        if (from.hasField(control)) {
            if (from.getFormat().getField(control).getType() == 'T' && from.rec().getValue(control) == null) {
                into.rec().setValue(control, (Object)new SimpleDataTable(into.rec().getDataTable(control).getFormat()));
                return;
            }
            into.rec().setValue(control, from.rec().getValue(control));
        }
    }

    private static void checkAndCopyControlStateVector(DataTable into, DataTable from, String control) {
        if (from.hasField(control)) {
            ControlStatesFilterCombiner.copyVector(into.rec().getDataTable(control), from.rec().getDataTable(control));
        }
    }

    private static void copyVariant(DataTable into, DataTable from) {
        ControlStatesFilterCombiner.validateVariantMatchType(into, from, false);
        Object fromValue = from.rec().getValue("value");
        into.rec().setValue("value", fromValue);
    }

    private static void copyVector(DataTable into, DataTable from) {
        int i;
        if (from == null) {
            from = into.clone();
        }
        ControlStatesFilterCombiner.validateVariantMatchType(into, from, true);
        for (i = into.getRecordCount() - 1; i >= 0; --i) {
            into.removeRecord(i);
        }
        for (i = 0; i < from.getRecordCount(); ++i) {
            into.addRecord(from.getRecord(i));
        }
    }

    private static void validateVariantContainer(DataTable variantContainer, boolean vector) {
        if (vector && variantContainer.getFieldCount() != 1) {
            throw new IllegalArgumentException("Illegal vector table format. Nx1 table is expected");
        }
        if (!(vector || variantContainer.getFieldCount() == 1 && variantContainer.getRecordCount() == 1)) {
            throw new IllegalArgumentException("Illegal variant table format. 1x1 table is expected");
        }
        if (!variantContainer.hasField("value")) {
            throw new IllegalArgumentException("Illegal variant table format. Field: value is expected");
        }
        FieldFormat valueField = variantContainer.getFormat("value");
        if (valueField.getType() != 'I' && valueField.getType() != 'L' && valueField.getType() != 'F' && valueField.getType() != 'E' && valueField.getType() != 'S' && valueField.getType() != 'D') {
            throw new IllegalArgumentException("Illegal variant table format. Numeric or String field type is expected");
        }
    }

    private static void validateVariantMatchType(DataTable into, DataTable from, boolean vector) {
        ControlStatesFilterCombiner.validateVariantContainer(into, vector);
        ControlStatesFilterCombiner.validateVariantContainer(from, vector);
        if (into.getFormat("value").getType() != from.getFormat("value").getType()) {
            throw new IllegalArgumentException("Incompatible variant formats");
        }
    }

    static {
        paneCombiner.put(1, ControlStatesFilterCombiner::numericPaneCombiner);
        paneCombiner.put(2, ControlStatesFilterCombiner::stringPaneCombiner);
        paneCombiner.put(3, ControlStatesFilterCombiner::booleanPaneCombiner);
        paneCombiner.put(4, ControlStatesFilterCombiner::colorPaneCombiner);
        paneCombiner.put(5, ControlStatesFilterCombiner::datePaneCombiner);
        paneCombiner.put(6, ControlStatesFilterCombiner::dataTablePaneCombiner);
        paneCombiner.put(7, ControlStatesFilterCombiner::dataBlockPaneCombiner);
    }
}

