/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.expression.Function;
import com.tibbo.aggregate.common.filter.ColumnFunctionOperation;
import com.tibbo.aggregate.common.filter.Expression;
import com.tibbo.aggregate.common.filter.Operation;
import com.tibbo.aggregate.common.filter.SmartFilterIllegalOperandException;
import com.tibbo.aggregate.common.filter.SmartFilterIllegalOperationException;

public abstract class SubstringFunctionOperation
extends ColumnFunctionOperation {
    private final Function func;

    public SubstringFunctionOperation(Function func, String name, Expression ... operands) {
        super(name, operands);
        if (operands.length != 2) {
            throw new SmartFilterIllegalOperationException(Cres.get().getString("smartFilterIllegalNumberOfOperandsInFunction") + ": " + this.getName());
        }
        this.func = func;
    }

    @Override
    public final Object evaluate() {
        Object columnValue = this.getColumn().evaluate();
        Object operandValue = this.operands[1].evaluate();
        if (columnValue == null || operandValue == null) {
            return false;
        }
        if (!(columnValue instanceof String)) {
            columnValue = columnValue + "";
        }
        if (!(operandValue instanceof String)) {
            throw new SmartFilterIllegalOperandException((Operation)this, String.class);
        }
        columnValue = ((String)columnValue).toLowerCase();
        operandValue = ((String)operandValue).toLowerCase();
        try {
            return this.func.execute(null, null, columnValue, operandValue);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

