/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter;

import com.tibbo.aggregate.common.filter.Expression;
import com.tibbo.aggregate.common.filter.FunctionOperation;
import com.tibbo.aggregate.common.filter.LastNextPeriodFunctionOperation;
import com.tibbo.aggregate.common.util.DateUtils;
import java.util.Calendar;
import java.util.Date;

public class NextHoursFunctionOperation
extends LastNextPeriodFunctionOperation {
    public NextHoursFunctionOperation(Expression[] operands) {
        super(FunctionOperation.FilterFunctions.NEXT_X_HOURS.getName(), operands);
    }

    @Override
    protected Object checkDate(Date column, Number operand) {
        Date end = DateUtils.getStartOfHour(new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(end);
        cal.add(11, operand.intValue());
        Date start = cal.getTime();
        return column.compareTo(start) >= 0 && column.compareTo(end) <= 0;
    }
}

