/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter;

import com.tibbo.aggregate.common.filter.Expression;
import com.tibbo.aggregate.common.filter.FunctionOperation;
import com.tibbo.aggregate.common.filter.LastNextPeriodFunctionOperation;
import com.tibbo.aggregate.common.util.DateUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;

public class LastYearsFunctionOperation
extends LastNextPeriodFunctionOperation {
    public LastYearsFunctionOperation(Expression[] operands) {
        super(FunctionOperation.FilterFunctions.LAST_X_YEARS.getName(), operands);
    }

    @Override
    protected Object checkDate(Date column, Number operand) {
        LocalDate date = LocalDate.now();
        Date end = DateUtils.getStartOfHour(new Date());
        return column.compareTo(Date.from((date = date.minusYears(operand.intValue())).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant())) >= 0 && column.compareTo(end) <= 0;
    }
}

