/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter;

import com.tibbo.aggregate.common.filter.ColumnFunctionOperation;
import com.tibbo.aggregate.common.filter.ColumnName;
import com.tibbo.aggregate.common.filter.Expression;
import com.tibbo.aggregate.common.filter.FunctionOperation;
import com.tibbo.aggregate.common.filter.Operation;
import com.tibbo.aggregate.common.filter.SmartFilterIllegalOperandException;
import com.tibbo.aggregate.common.util.DateUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class InFunctionOperation
extends ColumnFunctionOperation {
    public InFunctionOperation(Expression[] operands) {
        super(FunctionOperation.FilterFunctions.IN.getName(), operands);
        if (operands.length < 2) {
            throw new IllegalArgumentException("included in list is expected");
        }
    }

    @Override
    public Object evaluate() {
        Object value1 = this.operands[0].evaluate();
        if (value1 == null) {
            return null;
        }
        List<Object> value2 = Arrays.stream(this.operands).skip(1L).map(Expression::evaluate).collect(Collectors.toList());
        if (!(value1 instanceof Number || value1 instanceof String || value1 instanceof Date)) {
            throw new SmartFilterIllegalOperandException((Operation)this, Number.class, String.class, Date.class);
        }
        if (value2.stream().filter(v -> !(v instanceof Number)).filter(v -> !(v instanceof String)).anyMatch(v -> !(v instanceof Date))) {
            throw new SmartFilterIllegalOperandException((Operation)this, Number.class, String.class, Date.class);
        }
        Object operand = this.castAndNormalizeOperand(value1, value2);
        if (operand instanceof Number) {
            return value2.stream().anyMatch(o -> ((BigDecimal)o).compareTo(new BigDecimal(operand.toString())) == 0);
        }
        return value2.stream().anyMatch(o -> o.equals(operand));
    }

    private Object castAndNormalizeOperand(Object operand, List<Object> listOfValues) {
        if (operand instanceof Number) {
            for (int i = 0; i < listOfValues.size(); ++i) {
                Object lv = listOfValues.get(i);
                if (!(lv instanceof Number)) continue;
                listOfValues.set(i, new BigDecimal(lv.toString()));
            }
        } else if (operand instanceof Date) {
            String editor = ((ColumnName)this.operands[0]).getFieldFormat().getEditor();
            if ("date".equals(editor)) {
                LocalDate ld = ((Date)operand).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                operand = Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            ArrayList<Date> normalized = new ArrayList<Date>(listOfValues.size());
            try {
                for (Object v : listOfValues) {
                    Date parsed = DateUtils.parseSmart(v.toString());
                    normalized.add(parsed);
                }
            }
            catch (ParseException pe) {
                throw new SmartFilterIllegalOperandException((Operation)this, "Operand: \"" + listOfValues + "\" not a valid Date");
            }
            listOfValues.clear();
            listOfValues.addAll(normalized);
        }
        return operand;
    }
}

