/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.expression.AttributedObject;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.function.DefaultFunctions;
import com.tibbo.aggregate.common.expression.parser.ASTAddNode;
import com.tibbo.aggregate.common.expression.parser.ASTBitwiseAndNode;
import com.tibbo.aggregate.common.expression.parser.ASTBitwiseNotNode;
import com.tibbo.aggregate.common.expression.parser.ASTBitwiseOrNode;
import com.tibbo.aggregate.common.expression.parser.ASTBitwiseXorNode;
import com.tibbo.aggregate.common.expression.parser.ASTConditionalNode;
import com.tibbo.aggregate.common.expression.parser.ASTDivNode;
import com.tibbo.aggregate.common.expression.parser.ASTEQNode;
import com.tibbo.aggregate.common.expression.parser.ASTFalseNode;
import com.tibbo.aggregate.common.expression.parser.ASTFloatConstNode;
import com.tibbo.aggregate.common.expression.parser.ASTFunctionNode;
import com.tibbo.aggregate.common.expression.parser.ASTGENode;
import com.tibbo.aggregate.common.expression.parser.ASTGTNode;
import com.tibbo.aggregate.common.expression.parser.ASTLENode;
import com.tibbo.aggregate.common.expression.parser.ASTLTNode;
import com.tibbo.aggregate.common.expression.parser.ASTLeftShiftNode;
import com.tibbo.aggregate.common.expression.parser.ASTLogicalAndNode;
import com.tibbo.aggregate.common.expression.parser.ASTLogicalNotNode;
import com.tibbo.aggregate.common.expression.parser.ASTLogicalOrNode;
import com.tibbo.aggregate.common.expression.parser.ASTLongConstNode;
import com.tibbo.aggregate.common.expression.parser.ASTModNode;
import com.tibbo.aggregate.common.expression.parser.ASTMulNode;
import com.tibbo.aggregate.common.expression.parser.ASTNENode;
import com.tibbo.aggregate.common.expression.parser.ASTNullNode;
import com.tibbo.aggregate.common.expression.parser.ASTRegexMatchNode;
import com.tibbo.aggregate.common.expression.parser.ASTRightShiftNode;
import com.tibbo.aggregate.common.expression.parser.ASTStart;
import com.tibbo.aggregate.common.expression.parser.ASTStringConstNode;
import com.tibbo.aggregate.common.expression.parser.ASTSubtractNode;
import com.tibbo.aggregate.common.expression.parser.ASTTrueNode;
import com.tibbo.aggregate.common.expression.parser.ASTUnaryNode;
import com.tibbo.aggregate.common.expression.parser.ASTUnsignedRightShiftNode;
import com.tibbo.aggregate.common.expression.parser.ASTValueReferenceNode;
import com.tibbo.aggregate.common.expression.parser.ExpressionParserVisitor;
import com.tibbo.aggregate.common.expression.parser.SimpleNode;
import com.tibbo.aggregate.common.filter.BeginWithFunctionOperation;
import com.tibbo.aggregate.common.filter.BooleanLiteral;
import com.tibbo.aggregate.common.filter.ColumnName;
import com.tibbo.aggregate.common.filter.ContainsExFunctionOperation;
import com.tibbo.aggregate.common.filter.ContainsFunctionOperation;
import com.tibbo.aggregate.common.filter.DoesNotEqualOperation;
import com.tibbo.aggregate.common.filter.EndsWithFunctionOperation;
import com.tibbo.aggregate.common.filter.EqualsOperation;
import com.tibbo.aggregate.common.filter.Expression;
import com.tibbo.aggregate.common.filter.FunctionOperation;
import com.tibbo.aggregate.common.filter.GreaterOrEqualThanOperation;
import com.tibbo.aggregate.common.filter.GreaterThanOperation;
import com.tibbo.aggregate.common.filter.InFunctionOperation;
import com.tibbo.aggregate.common.filter.IsNotNullFunctionOperation;
import com.tibbo.aggregate.common.filter.IsNullFunctionOperation;
import com.tibbo.aggregate.common.filter.LastDaysFunctionOperation;
import com.tibbo.aggregate.common.filter.LastHoursFunctionOperation;
import com.tibbo.aggregate.common.filter.LastMonthsFunctionOperation;
import com.tibbo.aggregate.common.filter.LastWeeksFunctionOperation;
import com.tibbo.aggregate.common.filter.LastYearsFunctionOperation;
import com.tibbo.aggregate.common.filter.LessOrEqualThanOperation;
import com.tibbo.aggregate.common.filter.LessThanOperation;
import com.tibbo.aggregate.common.filter.LogicalAndOperation;
import com.tibbo.aggregate.common.filter.LogicalNotOperation;
import com.tibbo.aggregate.common.filter.LogicalOrOperation;
import com.tibbo.aggregate.common.filter.NextDaysFunctionOperation;
import com.tibbo.aggregate.common.filter.NextHoursFunctionOperation;
import com.tibbo.aggregate.common.filter.NextMonthsFunctionOperation;
import com.tibbo.aggregate.common.filter.NextWeeksFunctionOperation;
import com.tibbo.aggregate.common.filter.NextYearsFunctionOperation;
import com.tibbo.aggregate.common.filter.NullLiteral;
import com.tibbo.aggregate.common.filter.NumberLiteral;
import com.tibbo.aggregate.common.filter.OnAfterFunctionOperation;
import com.tibbo.aggregate.common.filter.OnBeforeFunctionOperation;
import com.tibbo.aggregate.common.filter.OnFunctionOperation;
import com.tibbo.aggregate.common.filter.SmartFilterParseException;
import com.tibbo.aggregate.common.filter.StringLiteral;
import com.tibbo.aggregate.common.filter.ThisHourFunctionOperation;
import com.tibbo.aggregate.common.filter.ThisMonthFunctionOperation;
import com.tibbo.aggregate.common.filter.ThisWeekFunctionOperation;
import com.tibbo.aggregate.common.filter.ThisYearFunctionOperation;
import com.tibbo.aggregate.common.filter.TodayFunctionOperation;
import com.tibbo.aggregate.common.filter.TomorrowFunctionOperation;
import com.tibbo.aggregate.common.filter.WrappingFunction;
import com.tibbo.aggregate.common.filter.YesterdayFunctionOperation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class FilterPredicateExpressionParserVisitor
implements ExpressionParserVisitor {
    public static int STACK_SIZE = 100;
    private Expression[] stack = new Expression[STACK_SIZE];
    int sp = -1;
    private static final Map<String, Class<? extends FunctionOperation>> filterFunctions = new HashMap<String, Class<? extends FunctionOperation>>();
    private static final Map<String, DefaultFunctions> funcDefs = new HashMap<String, DefaultFunctions>();

    private static void registerFunction(FunctionOperation.FilterFunctions def, Class<? extends FunctionOperation> funcClass) {
        filterFunctions.put(def.getName(), funcClass);
    }

    private static void registerWrappedFunction(DefaultFunctions defaultFunction) {
        funcDefs.put(defaultFunction.getName(), defaultFunction);
    }

    public Expression getRootExpression() {
        if (this.sp != 0) {
            throw new IllegalStateException("Stack pointer does not point to root expression");
        }
        return this.stack[this.sp];
    }

    @Override
    public AttributedObject visit(SimpleNode node, EvaluationEnvironment data) {
        return null;
    }

    @Override
    public AttributedObject visit(ASTStart node, EvaluationEnvironment data) {
        node.jjtGetChild(0).jjtAccept(this, data);
        return null;
    }

    @Override
    public AttributedObject visit(ASTConditionalNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTLogicalOrNode node, EvaluationEnvironment data) {
        this.processBinaryVisit(node, data, LogicalOrOperation::new);
        return null;
    }

    @Override
    public AttributedObject visit(ASTLogicalAndNode node, EvaluationEnvironment data) {
        this.processBinaryVisit(node, data, LogicalAndOperation::new);
        return null;
    }

    @Override
    public AttributedObject visit(ASTBitwiseOrNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTBitwiseXorNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTBitwiseAndNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTEQNode node, EvaluationEnvironment data) {
        this.processBinaryVisit(node, data, EqualsOperation::new);
        return null;
    }

    @Override
    public AttributedObject visit(ASTNENode node, EvaluationEnvironment data) {
        this.processBinaryVisit(node, data, DoesNotEqualOperation::new);
        return null;
    }

    @Override
    public AttributedObject visit(ASTRegexMatchNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTLTNode node, EvaluationEnvironment data) {
        this.processBinaryVisit(node, data, LessThanOperation::new);
        return null;
    }

    @Override
    public AttributedObject visit(ASTGTNode node, EvaluationEnvironment data) {
        this.processBinaryVisit(node, data, GreaterThanOperation::new);
        return null;
    }

    @Override
    public AttributedObject visit(ASTLENode node, EvaluationEnvironment data) {
        this.processBinaryVisit(node, data, LessOrEqualThanOperation::new);
        return null;
    }

    @Override
    public AttributedObject visit(ASTGENode node, EvaluationEnvironment data) {
        this.processBinaryVisit(node, data, GreaterOrEqualThanOperation::new);
        return null;
    }

    @Override
    public AttributedObject visit(ASTRightShiftNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTUnsignedRightShiftNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTLeftShiftNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTAddNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTSubtractNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTMulNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTDivNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTModNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTUnaryNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTLogicalNotNode node, EvaluationEnvironment data) {
        node.jjtGetChild(0).jjtAccept(this, data);
        Expression expression = this.pop();
        this.push(new LogicalNotOperation(expression));
        return null;
    }

    @Override
    public AttributedObject visit(ASTBitwiseNotNode node, EvaluationEnvironment data) {
        throw new SmartFilterParseException(Cres.get().getString("smartFilterOperationNotSupported") + ": " + node);
    }

    @Override
    public AttributedObject visit(ASTFunctionNode node, EvaluationEnvironment data) {
        String funcName = node.name;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        Expression[] operands = new Expression[node.jjtGetNumChildren()];
        for (int i = node.jjtGetNumChildren() - 1; i >= 0; --i) {
            operands[i] = this.pop();
        }
        Class<? extends FunctionOperation> funcClass = filterFunctions.get(funcName);
        if (funcClass != null) {
            try {
                Constructor<? extends FunctionOperation> constructor = funcClass.getConstructor(operands.getClass());
                FunctionOperation functionOperation = constructor.newInstance(new Object[]{operands});
                this.push(functionOperation);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            DefaultFunctions aggFunction = funcDefs.get(funcName);
            if (aggFunction != null) {
                WrappingFunction wf = new WrappingFunction(aggFunction.impl, operands);
                this.push(wf);
            } else {
                throw new SmartFilterParseException(Cres.get().getString("smartFilterUnknownFunction") + ": " + funcName);
            }
        }
        return null;
    }

    @Override
    public AttributedObject visit(ASTValueReferenceNode node, EvaluationEnvironment data) {
        this.push(new ColumnName(node.uriImage));
        return null;
    }

    @Override
    public AttributedObject visit(ASTLongConstNode node, EvaluationEnvironment data) {
        this.push(new NumberLiteral(node.val));
        return null;
    }

    @Override
    public AttributedObject visit(ASTFloatConstNode node, EvaluationEnvironment data) {
        Number result = node.floatVal;
        if (result == null) {
            result = node.doubleVal;
        }
        this.push(new NumberLiteral(result));
        return null;
    }

    @Override
    public AttributedObject visit(ASTStringConstNode node, EvaluationEnvironment data) {
        this.push(new StringLiteral(node.val));
        return null;
    }

    @Override
    public AttributedObject visit(ASTNullNode node, EvaluationEnvironment data) {
        this.push(new NullLiteral());
        return null;
    }

    @Override
    public AttributedObject visit(ASTTrueNode node, EvaluationEnvironment data) {
        this.push(new BooleanLiteral(true));
        return null;
    }

    @Override
    public AttributedObject visit(ASTFalseNode node, EvaluationEnvironment data) {
        this.push(new BooleanLiteral(false));
        return null;
    }

    private void push(Expression expression) {
        this.stack[++this.sp] = expression;
    }

    private Expression pop() {
        return this.stack[this.sp--];
    }

    private void processBinaryVisit(SimpleNode node, EvaluationEnvironment data, BiFunction<Expression, Expression, Expression> expressionProvider) {
        node.jjtGetChild(0).jjtAccept(this, data);
        node.jjtGetChild(1).jjtAccept(this, data);
        Expression right = this.pop();
        Expression left = this.pop();
        this.push(expressionProvider.apply(left, right));
    }

    static {
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.CONTAINS, ContainsFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.BEGINS_WITH, BeginWithFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.END_WITH, EndsWithFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.IN, InFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.ON, OnFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.ON_OR_AFTER, OnAfterFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.ON_OR_BEFORE, OnBeforeFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.YESTERDAY, YesterdayFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.TODAY, TodayFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.TOMORROW, TomorrowFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.THIS_HOUR, ThisHourFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.THIS_WEEK, ThisWeekFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.THIS_MONTH, ThisMonthFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.THIS_YEAR, ThisYearFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.LAST_X_HOURS, LastHoursFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.NEXT_X_HOURS, NextHoursFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.LAST_X_DAYS, LastDaysFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.NEXT_X_DAYS, NextDaysFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.LAST_X_WEEKS, LastWeeksFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.NEXT_X_WEEKS, NextWeeksFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.LAST_X_MONTHS, LastMonthsFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.NEXT_X_MONTHS, NextMonthsFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.LAST_X_YEARS, LastYearsFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.NEXT_X_YEARS, NextYearsFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.IS_NULL, IsNullFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.IS_NOT_NULL, IsNotNullFunctionOperation.class);
        FilterPredicateExpressionParserVisitor.registerWrappedFunction(DefaultFunctions.DATE);
        FilterPredicateExpressionParserVisitor.registerWrappedFunction(DefaultFunctions.RECORDS);
        FilterPredicateExpressionParserVisitor.registerWrappedFunction(DefaultFunctions.ENCODE);
        FilterPredicateExpressionParserVisitor.registerFunction(FunctionOperation.FilterFunctions.SIMPLE_CONTAINS, ContainsExFunctionOperation.class);
    }
}

