/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.parser.ASTStart;
import com.tibbo.aggregate.common.expression.parser.ExpressionParser;
import com.tibbo.aggregate.common.expression.parser.ParseException;
import com.tibbo.aggregate.common.filter.ColumnName;
import com.tibbo.aggregate.common.filter.DataSupplier;
import com.tibbo.aggregate.common.filter.Expression;
import com.tibbo.aggregate.common.filter.FilterPredicateExpressionParserVisitor;
import com.tibbo.aggregate.common.filter.SmartFilterEvaluationException;
import com.tibbo.aggregate.common.filter.SmartFilterRuntimeException;
import java.io.CharArrayReader;
import java.util.function.Supplier;

public class FilterEvaluator {
    private final TableFormat tableFormat;
    private final Expression rootExpression;
    private final DataSupplier dataSupplier = new DataSupplierImpl();
    private DataTable dataTable;
    private int cursor = 0;

    public FilterEvaluator(TableFormat tableFormat, String filterExpression) throws ParseException {
        Expression visitorExpression = null;
        if (!filterExpression.isEmpty()) {
            ExpressionParser parser = new ExpressionParser(new CharArrayReader(filterExpression.toCharArray()));
            ASTStart root = parser.Start();
            FilterPredicateExpressionParserVisitor visitor = new FilterPredicateExpressionParserVisitor();
            root.jjtAccept(visitor, null);
            visitorExpression = visitor.getRootExpression();
        }
        this.tableFormat = tableFormat;
        this.rootExpression = visitorExpression;
        this.bindReferences(this.rootExpression);
    }

    public FilterEvaluator(String filterExpression) throws ParseException {
        ExpressionParser parser = new ExpressionParser(new CharArrayReader(filterExpression.toCharArray()));
        ASTStart root = parser.Start();
        FilterPredicateExpressionParserVisitor visitor = new FilterPredicateExpressionParserVisitor();
        root.jjtAccept(visitor, null);
        this.rootExpression = visitor.getRootExpression();
        this.tableFormat = null;
    }

    public static void validateExpression(TableFormat format, String expression) {
        if (expression == null || expression.isEmpty() || format == null || format.getFields().isEmpty()) {
            return;
        }
        try {
            new FilterEvaluator(format, expression);
        }
        catch (Throwable e) {
            if (e instanceof SmartFilterEvaluationException) {
                return;
            }
            throw new SmartFilterRuntimeException("Invalid Expression: " + expression);
        }
    }

    public Expression getRootExpression() {
        return this.rootExpression;
    }

    public void setDataTable(DataTable dataTable) {
        this.dataTable = dataTable;
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public DataTable filterTable() {
        SimpleDataTable result = new SimpleDataTable(this.tableFormat);
        this.cursor = 0;
        while (this.cursor < this.dataTable.getRecordCount()) {
            if (this.rootExpression != null) {
                Boolean predicate = (Boolean)this.rootExpression.evaluate();
                if (predicate != null && predicate.booleanValue()) {
                    result.addRecord(this.dataTable.getRecord(this.cursor));
                }
            } else {
                result.addRecord(this.dataTable.getRecord(this.cursor));
            }
            ++this.cursor;
        }
        return result;
    }

    private void bindReferences(Expression expression) {
        if (expression != null) {
            if (expression instanceof ColumnName) {
                ColumnName cn = (ColumnName)expression;
                cn.setDataSupplier(this.dataSupplier);
                cn.bind(this.tableFormat);
            }
            for (int i = 0; i < expression.getChildren().length; ++i) {
                this.bindReferences(expression.getChildren()[i]);
            }
        }
    }

    private class DataRecordSupplier
    implements Supplier<DataRecord> {
        private DataRecordSupplier() {
        }

        @Override
        public DataRecord get() {
            return FilterEvaluator.this.dataTable.getRecord(FilterEvaluator.this.cursor);
        }
    }

    private class DataSupplierImpl
    implements DataSupplier {
        private final Supplier<DataRecord> dataRecordSupplier;

        private DataSupplierImpl() {
            this.dataRecordSupplier = new DataRecordSupplier();
        }

        @Override
        public Supplier<DataRecord> getDataRecordSupplier() {
            return this.dataRecordSupplier;
        }

        @Override
        public TableFormat getTableFormat() {
            return FilterEvaluator.this.tableFormat;
        }
    }
}

