/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.filter.FilterApiConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ControlStatesFilterReducer {
    private static final Map<Integer, Function<DataRecord, Boolean>> emptyPanePredicates = new HashMap<Integer, Function<DataRecord, Boolean>>();

    public static DataTable reduceFilter(DataTable initialFilter) {
        if (!FilterApiConstants.TF_COMPONENT_SMART_FILTER.equals(initialFilter.getFormat())) {
            throw new IllegalArgumentException("Illegal smart filter table format");
        }
        SimpleDataTable result = new SimpleDataTable(FilterApiConstants.TF_COMPONENT_SMART_FILTER);
        for (int i = 0; i < initialFilter.getRecordCount(); ++i) {
            DataRecord dr = initialFilter.getRecord(i);
            Integer paneType = dr.getInt("COMPONENT_SMART_FILTER_TYPE");
            Function<DataRecord, Boolean> emptyPredicate = emptyPanePredicates.get(paneType);
            if (emptyPredicate.apply(dr).booleanValue()) continue;
            result.addRecord(dr);
        }
        return result;
    }

    private static Boolean numericEmptyPanePredicate(DataRecord columnFilter) {
        DataTable pane = columnFilter.getDataTable("COMPONENT_SMART_FILTER_STATE");
        return pane.rec().getInt("PANE_FIELD_VALUE_PRESENCE") == 1 && ControlStatesFilterReducer.emptyVariant(pane.rec().getDataTable("PANE_FIELD_EQUALS")) != false && ControlStatesFilterReducer.emptyVector(pane.rec().getDataTable("PANE_FIELD_INCLUDED_IN")) != false && ControlStatesFilterReducer.emptyVariant(pane.rec().getDataTable("PANE_FIELD_DOES_NOT_EQUAL")) != false && ControlStatesFilterReducer.emptyVariant(pane.rec().getDataTable("PANE_FIELD_GREATER_THAN")) != false && ControlStatesFilterReducer.emptyVariant(pane.rec().getDataTable("PANE_FIELD_GREATER_OR_EQUAL_THAN")) != false && ControlStatesFilterReducer.emptyVariant(pane.rec().getDataTable("PANE_FIELD_LESS_THAN")) != false && ControlStatesFilterReducer.emptyVariant(pane.rec().getDataTable("PANE_FIELD_LESS_OR_EQUAL_THAN")) != false;
    }

    private static Boolean stringEmptyPanePredicate(DataRecord columnFilter) {
        DataTable pane = columnFilter.getDataTable("COMPONENT_SMART_FILTER_STATE");
        return pane.rec().getInt("PANE_FIELD_VALUE_PRESENCE") == 1 && pane.rec().getString("PANE_FIELD_EQUALS") == null && ControlStatesFilterReducer.emptyVector(pane.rec().getDataTable("PANE_FIELD_INCLUDED_IN")) != false && pane.rec().getString("PANE_FIELD_DOES_NOT_EQUAL") == null && pane.rec().getString("PANE_FIELD_CONTAINS") == null && pane.rec().getString("PANE_FIELD_DOES_NOT_CONTAIN") == null && pane.rec().getString("PANE_FIELD_BEGINS_WITH") == null && pane.rec().getString("PANE_FIELD_DOES_NOT_BEGIN_WITH") == null && pane.rec().getString("PANE_FIELD_ENDS_WITH") == null && pane.rec().getString("PANE_FIELD_DOES_NOT_END_WITH") == null;
    }

    private static Boolean booleanEmptyPanePredicate(DataRecord columnFilter) {
        DataTable pane = columnFilter.getDataTable("COMPONENT_SMART_FILTER_STATE");
        return pane.rec().getInt("PANE_FIELD_VALUE_PRESENCE") == 1 && pane.rec().getInt("PANE_FIELD_EQUALS") == 1;
    }

    private static Boolean colorEmptyPanePredicate(DataRecord columnFilter) {
        DataTable pane = columnFilter.getDataTable("COMPONENT_SMART_FILTER_STATE");
        return pane.rec().getInt("PANE_FIELD_VALUE_PRESENCE") == 1 && pane.rec().getColor("PANE_FIELD_EQUALS") == null && pane.rec().getColor("PANE_FIELD_DOES_NOT_EQUAL") == null;
    }

    private static Boolean dateEmptyPanePredicate(DataRecord columnFilter) {
        DataTable pane = columnFilter.getDataTable("COMPONENT_SMART_FILTER_STATE");
        return pane.rec().getInt("PANE_FIELD_VALUE_PRESENCE") == 1 && pane.rec().getDate("PANE_FIELD_EQUALS") == null && ControlStatesFilterReducer.emptyVector(pane.rec().getDataTable("PANE_FIELD_INCLUDED_IN")) != false && pane.rec().getDate("PANE_FIELD_DOES_NOT_EQUAL") == null && pane.rec().getDate("PANE_FIELD_GREATER_THAN") == null && pane.rec().getDate("PANE_FIELD_GREATER_OR_EQUAL_THAN") == null && pane.rec().getDate("PANE_FIELD_LESS_THAN") == null && pane.rec().getDate("PANE_FIELD_LESS_OR_EQUAL_THAN") == null && pane.rec().getLong("PANE_FIELD_LAST_INTERVAL") == null && ControlStatesFilterReducer.emptyTable(pane.rec().getDataTable("PANE_FIELD_DATE_TIME_RANGE")) && pane.rec().getInt("PANE_FIELD_CURRENT_INTERVAL") == 0 && pane.rec().getLong("PANE_FIELD_NEXT_INTERVAL") == null;
    }

    private static Boolean dataTableEmptyPanePredicate(DataRecord columnFilter) {
        DataTable pane = columnFilter.getDataTable("COMPONENT_SMART_FILTER_STATE");
        return pane.rec().getInt("PANE_FIELD_VALUE_PRESENCE") == 1 && pane.rec().getString("PANE_FIELD_CONTAINS") == null && pane.rec().getString("PANE_FIELD_DOES_NOT_CONTAIN") == null && pane.rec().getInt("PANE_FIELD_RECORD_COUNT") == null;
    }

    private static Boolean dataBlockEmptyPanePredicate(DataRecord columnFilter) {
        DataTable pane = columnFilter.getDataTable("COMPONENT_SMART_FILTER_STATE");
        return pane.rec().getInt("PANE_FIELD_VALUE_PRESENCE") == 1;
    }

    private static Boolean emptyVariant(DataTable variant) {
        if (variant.getRecordCount() != 1 || variant.getFieldCount() != 1) {
            throw new IllegalArgumentException("Illegal variant table. 1x1 table is expected");
        }
        return variant.rec().getValue("value") == null;
    }

    private static Boolean emptyVector(DataTable vector) {
        if (vector.getFieldCount() != 1) {
            throw new IllegalArgumentException("Illegal vector table. Nx1 table is expected");
        }
        return vector.getRecordCount() == 0;
    }

    private static boolean emptyTable(DataTable dataTable) {
        return dataTable.getRecordCount() == 0;
    }

    static {
        emptyPanePredicates.put(1, ControlStatesFilterReducer::numericEmptyPanePredicate);
        emptyPanePredicates.put(2, ControlStatesFilterReducer::stringEmptyPanePredicate);
        emptyPanePredicates.put(3, ControlStatesFilterReducer::booleanEmptyPanePredicate);
        emptyPanePredicates.put(4, ControlStatesFilterReducer::colorEmptyPanePredicate);
        emptyPanePredicates.put(5, ControlStatesFilterReducer::dateEmptyPanePredicate);
        emptyPanePredicates.put(6, ControlStatesFilterReducer::dataTableEmptyPanePredicate);
        emptyPanePredicates.put(7, ControlStatesFilterReducer::dataBlockEmptyPanePredicate);
    }
}

