/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.expression.function.DefaultFunctions;
import com.tibbo.aggregate.common.filter.Expression;
import com.tibbo.aggregate.common.filter.FunctionOperation;
import com.tibbo.aggregate.common.filter.Operation;
import com.tibbo.aggregate.common.filter.SmartFilterIllegalOperandException;
import com.tibbo.aggregate.common.filter.SmartFilterIllegalOperationException;

public class ContainsExFunctionOperation
extends FunctionOperation {
    public ContainsExFunctionOperation(Expression ... operands) {
        super(FunctionOperation.FilterFunctions.SIMPLE_CONTAINS.getName(), operands);
        if (operands.length < 2) {
            throw new SmartFilterIllegalOperationException(Cres.get().getString("smartFilterIllegalNumberOfOperandsInFunction") + ": " + this.getName());
        }
    }

    @Override
    public Object evaluate() {
        Object first = this.operands[0].evaluate();
        Object second = this.operands[1].evaluate();
        if (!(first instanceof String) || !(second instanceof String)) {
            throw new SmartFilterIllegalOperandException((Operation)this, String.class);
        }
        try {
            return DefaultFunctions.CONTAINS.impl.execute(null, null, first, second);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

