/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.filter.ColumnFunctionOperation;
import com.tibbo.aggregate.common.filter.ColumnName;
import com.tibbo.aggregate.common.filter.Expression;
import com.tibbo.aggregate.common.filter.Operation;
import com.tibbo.aggregate.common.filter.SmartFilterEvaluationException;
import com.tibbo.aggregate.common.filter.SmartFilterIllegalOperandException;
import com.tibbo.aggregate.common.util.DateUtils;
import java.text.ParseException;
import java.util.Date;

public abstract class CompareDateFunctionOperation
extends ColumnFunctionOperation {
    public CompareDateFunctionOperation(String name, Expression ... operands) {
        super(name, operands);
        if (operands.length != 2) {
            throw new IllegalArgumentException("Illegal operand number in function: " + this.getName());
        }
    }

    @Override
    public final Object evaluate() {
        ColumnName columnName = this.getColumn();
        Object columnValue = columnName.evaluate();
        Object operandValue = this.operands[1].evaluate();
        if (columnValue == null || operandValue == null) {
            return null;
        }
        if (!(columnValue instanceof Date)) {
            throw new SmartFilterEvaluationException(Cres.get().getString("smartFilterIllegalColumnTypeDateExpected") + ": " + columnName.getName());
        }
        if (operandValue instanceof String) {
            try {
                operandValue = DateUtils.parseSmart((String)operandValue);
            }
            catch (ParseException e) {
                throw new SmartFilterIllegalOperandException((Operation)this, Cres.get().getString("smartFilterOperandNotValidDate") + ": " + operandValue);
            }
        }
        Date column = (Date)columnValue;
        Date operand = (Date)operandValue;
        return this.compareDate(column, operand);
    }

    public abstract boolean compareDate(Date var1, Date var2);
}

