/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.filter;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.filter.DataSupplier;
import com.tibbo.aggregate.common.filter.Identifier;
import com.tibbo.aggregate.common.filter.SmartFilterDataBindingException;

public final class ColumnName
extends Identifier {
    private DataSupplier dataSupplier;
    private FieldFormat<?> fieldFormat;

    public ColumnName(String name) {
        super(name);
    }

    @Override
    protected Object fetchValue() {
        if (this.dataSupplier == null) {
            throw new IllegalStateException("Data supplier is not set");
        }
        DataRecord dr = this.dataSupplier.getDataRecordSupplier().get();
        FieldFormat ff = dr.getFormat().getField(this.getName());
        Object straightValue = dr.getValue(this.getName());
        if (ff.hasSelectionValues()) {
            String value = ff.getSelectionValues().get(straightValue);
            return value != null ? value : straightValue.toString();
        }
        return straightValue;
    }

    public void setDataSupplier(DataSupplier dataSupplier) {
        this.dataSupplier = dataSupplier;
    }

    public DataSupplier getDataSupplier() {
        return this.dataSupplier;
    }

    public FieldFormat<?> getFieldFormat() {
        return this.fieldFormat;
    }

    public void bind(TableFormat tableFormat) {
        this.fieldFormat = tableFormat.getFields().stream().filter(ff -> !ff.isHidden()).filter(ff -> ff.getName().equalsIgnoreCase(this.getName())).findAny().orElse(null);
        if (this.fieldFormat == null) {
            throw new SmartFilterDataBindingException(this.getName(), Cres.get().getString("smartFilterUnknownColumnError") + ": " + this.getName());
        }
    }
}

