/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.util.update;

import com.tibbo.aggregate.common.expression.AttributedObject;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.parser.ASTValueReferenceNode;
import com.tibbo.aggregate.common.expression.util.ReferencesFinderVisitor;

class SingleContextFinderVisitor
extends ReferencesFinderVisitor {
    private final String expressionText;
    private final String oldContext;
    private final String newContext;

    SingleContextFinderVisitor(String expressionText, String oldContext, String newContext) {
        this.expressionText = expressionText;
        this.oldContext = oldContext;
        this.newContext = newContext;
    }

    @Override
    public AttributedObject visit(ASTValueReferenceNode node, EvaluationEnvironment data) {
        Reference currentReference = new Reference(node.uriImage);
        String currentContext = currentReference.getContext();
        if (!this.oldContext.equals(currentContext)) {
            return null;
        }
        int beginLine = node.jjtGetFirstToken().beginLine;
        int beginColumn = node.jjtGetFirstToken().beginColumn;
        int endLine = node.jjtGetLastToken().endLine;
        int endColumn = node.jjtGetLastToken().endColumn;
        if (beginLine != endLine || beginLine != 1) {
            throw new IllegalArgumentException(String.format("Incorrect reference format (beginLine is %d and endLine is %d): %s", beginLine, endLine, node.uriImage));
        }
        currentReference.setContext(this.newContext);
        String updatedReference = currentReference.getImage();
        String sourceReference = this.expressionText.substring(beginColumn - 1, endColumn);
        String updatedExpression = this.expressionText.replace(sourceReference, updatedReference);
        throw new SinglePassFinishedException(updatedExpression);
    }

    static class SinglePassFinishedException
    extends RuntimeException {
        private final String updatedExpression;

        SinglePassFinishedException(String updatedExpression) {
            this.updatedExpression = updatedExpression;
        }

        String getUpdatedExpression() {
            return this.updatedExpression;
        }
    }
}

