/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.util.update;

import com.google.common.base.Preconditions;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.ParsedExpressionCache;
import com.tibbo.aggregate.common.expression.parser.ASTStart;
import com.tibbo.aggregate.common.expression.util.update.SingleContextFinderVisitor;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import javax.annotation.Nonnull;

public class ReferencesContextUpdater {
    private final String oldContext;
    private final String newContext;

    public ReferencesContextUpdater(String oldContext, String newContext) {
        Preconditions.checkArgument((oldContext != null ? 1 : 0) != 0, (Object)"Old context must not be null");
        Preconditions.checkArgument((newContext != null ? 1 : 0) != 0, (Object)"New context must not be null");
        Preconditions.checkArgument((!oldContext.equals(newContext) ? 1 : 0) != 0, (String)"New context must not be equal to the old one: %s", (Object)oldContext);
        this.oldContext = oldContext;
        this.newContext = newContext;
    }

    public Expression updateContextInExpressionReferences(@Nonnull Expression sourceExpression) throws SyntaxErrorException {
        Expression updatedExpression;
        String updatedExpressionText;
        if (StringUtils.isEmpty(sourceExpression.getText())) {
            return sourceExpression;
        }
        CharSequence[] sourceExpressionLines = sourceExpression.getText().split("\r?\n");
        if (sourceExpressionLines.length == 1) {
            updatedExpressionText = sourceExpression.getText();
            updatedExpression = sourceExpression;
        } else {
            updatedExpressionText = String.join((CharSequence)" ", sourceExpressionLines);
            updatedExpression = new Expression(updatedExpressionText);
        }
        boolean madeAnyChanges = false;
        while (true) {
            ASTStart astRoot = ParsedExpressionCache.getCachedAstRoot(updatedExpressionText);
            SingleContextFinderVisitor visitor = new SingleContextFinderVisitor(updatedExpressionText, this.oldContext, this.newContext);
            try {
                astRoot.jjtAccept(visitor, null);
            }
            catch (SingleContextFinderVisitor.SinglePassFinishedException e) {
                if (Log.EXPRESSIONS.isDebugEnabled()) {
                    Log.EXPRESSIONS.debug((Object)String.format("Updating expression:\n%s\nto:\n%s", updatedExpressionText, e.getUpdatedExpression()));
                }
                updatedExpressionText = e.getUpdatedExpression();
                updatedExpression = new Expression(updatedExpressionText);
                madeAnyChanges = true;
                continue;
            }
            break;
        }
        return madeAnyChanges ? updatedExpression : sourceExpression;
    }
}

