/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.util;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.util.Tracer;

public class ContextExpressionTracer
implements Tracer {
    public static final String E_TRACE = "trace";
    public static final String EF_TRACE_VALUE = "value";
    public static final String EF_TRACE_MESSAGE = "message";
    private static final TableFormat EFT_TRACE = new TableFormat(1, 1);
    private final Context context;
    private final String traceEventGroup;

    public ContextExpressionTracer(Context context, String traceEventGroup) {
        this.context = context;
        this.traceEventGroup = traceEventGroup;
        this.install();
    }

    public void install() {
        Context target = this.getContext();
        if (target == null) {
            return;
        }
        if (target.getEventDefinition(E_TRACE) != null) {
            return;
        }
        EventDefinition ed = new EventDefinition(E_TRACE, EFT_TRACE, Cres.get().getString(E_TRACE));
        ed.setGroup(this.traceEventGroup);
        target.addEventDefinition(ed);
    }

    @Override
    public void trace(Object value, String message) {
        this.install();
        Context target = this.getContext();
        target.fireEvent(E_TRACE, value != null ? value.toString() : null, message);
    }

    protected Context getContext() {
        return this.context;
    }

    static {
        EFT_TRACE.addField("<value><S><F=N><D=" + Cres.get().getString(EF_TRACE_VALUE) + ">");
        EFT_TRACE.addField("<message><S><F=N><D=" + Cres.get().getString(EF_TRACE_MESSAGE) + ">");
    }
}

