/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.parser;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableUtils;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.AttributedObject;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class NodeEvaluationDetails {
    private static final String FIELD_NODE = "node";
    private static final String FIELD_RESULT = "result";
    private static final String FIELD_TIMESTAMP = "timestamp";
    private static final String FIELD_QUALITY = "quality";
    private static final String FIELD_CHILDREN = "children";
    private static final String FIELD_RESULT_VALUE = "value";
    public static TableFormat FORMAT = new TableFormat();
    private String nodeImage;
    private AttributedObject nodeResult;
    private List<NodeEvaluationDetails> children = new LinkedList<NodeEvaluationDetails>();

    public String getNodeImage() {
        return this.nodeImage;
    }

    public void setNodeImage(String nodeImage) {
        this.nodeImage = nodeImage;
    }

    public AttributedObject getNodeResult() {
        return this.nodeResult;
    }

    public void setNodeResult(AttributedObject nodeResult) {
        this.nodeResult = nodeResult;
    }

    public List<NodeEvaluationDetails> getChildren() {
        return this.children;
    }

    public void setChildren(List<NodeEvaluationDetails> children) {
        this.children = children;
    }

    public void addChild(NodeEvaluationDetails child) {
        this.children.add(child);
    }

    public DataTable toDataTable() {
        return this.toDataRecord().wrap();
    }

    public DataRecord toDataRecord() {
        DataRecord dr = new DataRecord(FORMAT);
        dr.addString(this.getNodeImage());
        AttributedObject nr = this.getNodeResult();
        dr.addDataTable(nr != null && nr.getValue() != null ? DataTableUtils.wrapToTable(Collections.singletonMap(FIELD_RESULT_VALUE, nr.getValue())) : null);
        dr.addDate(nr != null ? nr.getTimestamp() : null);
        dr.addInt(nr != null ? nr.getQuality() : null);
        if (this.children.size() > 0) {
            SimpleDataTable kids = new SimpleDataTable(FORMAT);
            for (NodeEvaluationDetails ned : this.children) {
                kids.addRecord(ned.toDataRecord());
            }
            dr.addDataTable(kids);
        } else {
            dr.addDataTable(null);
        }
        return dr;
    }

    static {
        FORMAT.addField("<node><S><F=N><" + Cres.get().getString(FIELD_NODE) + ">");
        FORMAT.addField("<result><T><F=N><" + Cres.get().getString(FIELD_RESULT) + ">");
        FORMAT.addField("<timestamp><D><F=NA><" + Cres.get().getString(FIELD_TIMESTAMP) + ">");
        FORMAT.addField("<quality><I><F=NA>A<" + Cres.get().getString(FIELD_QUALITY) + ">");
        FORMAT.addField("<children><T><F=N><" + Cres.get().getString(FIELD_CHILDREN) + ">");
        FORMAT.setNamingExpression("print({}, \"{node}\", \", \")");
    }
}

