/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.function.table;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableReplication;
import com.tibbo.aggregate.common.datatable.DataTableUtils;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Function;
import com.tibbo.aggregate.common.expression.function.AbstractFunction;
import java.util.LinkedList;

public class SubtableFunction
extends AbstractFunction {
    public SubtableFunction() {
        super("subtable", Function.GROUP_DATA_TABLE_PROCESSING, "DataTable table, Integer firstRecord, Integer recordCount, String field1, String field2, ...", "DataTable", Cres.get().getString("fDescSubtable"));
    }

    @Override
    public Object execute(Evaluator evaluator, EvaluationEnvironment environment, Object ... parameters) throws EvaluationException {
        boolean oldVersion;
        this.checkParameters(2, true, parameters);
        this.checkParameterType(0, parameters[0], DataTable.class);
        DataTable table = (DataTable)parameters[0];
        boolean bl = oldVersion = parameters.length < 4;
        if (parameters.length >= 4) {
            oldVersion |= parameters[1] != null && !Number.class.isAssignableFrom(parameters[1].getClass()) && parameters[2] != null && !Number.class.isAssignableFrom(parameters[2].getClass());
        }
        if (oldVersion) {
            return SubtableFunction.oldSubtable(table, parameters);
        }
        return this.newSubtable(table, parameters);
    }

    private Object newSubtable(DataTable table, Object[] parameters) {
        Integer recordCount;
        Integer firstRecord = parameters[1] != null ? Integer.valueOf(((Number)parameters[1]).intValue()) : null;
        Integer n = recordCount = parameters[2] != null ? Integer.valueOf(((Number)parameters[2]).intValue()) : null;
        if (firstRecord == null) {
            firstRecord = 0;
        }
        if (recordCount == null) {
            recordCount = table.getRecordCount();
        }
        LinkedList<String> fields = new LinkedList<String>();
        for (int i = 3; i < parameters.length; ++i) {
            fields.add(parameters[i].toString());
        }
        TableFormat rf = new TableFormat(Math.min(table.getFormat().getMinRecords(), recordCount), table.getFormat().getMaxRecords());
        rf.setBindings(DataTableUtils.filterBindings(table.getFormat(), fields));
        for (String field : fields) {
            FieldFormat ff = table.getFormat(field);
            if (ff == null) continue;
            rf.addField(ff);
        }
        SimpleDataTable result = new SimpleDataTable(rf);
        int lastRecord = firstRecord + recordCount;
        for (int i = firstRecord.intValue(); i < lastRecord && i < table.getRecordCount(); ++i) {
            DataRecord rec = result.addRecord();
            DataTableReplication.copyRecord(table.getRecord(i), rec, true, true);
        }
        return result;
    }

    private static DataTable oldSubtable(DataTable table, Object[] parameters) {
        LinkedList<String> fields = new LinkedList<String>();
        for (int i = 1; i < parameters.length; ++i) {
            fields.add(parameters[i].toString());
        }
        return DataTableUtils.makeSubtable(table, fields);
    }
}

