/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.function.table;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableReplication;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Function;
import com.tibbo.aggregate.common.expression.function.AbstractFunction;
import java.util.LinkedHashSet;

public class DistinctFunction
extends AbstractFunction {
    public DistinctFunction() {
        super("distinct", Function.GROUP_DATA_TABLE_PROCESSING, "DataTable table", "DataTable", Cres.get().getString("fDescDistinct"));
    }

    @Override
    public Object execute(Evaluator evaluator, EvaluationEnvironment environment, Object ... parameters) throws EvaluationException {
        this.checkParameters(1, false, parameters);
        this.checkParameterType(0, parameters[0], DataTable.class);
        DataTable source = (DataTable)parameters[0];
        TableFormat resultFormat = source.getFormat().clone();
        resultFormat.setMinRecords(0);
        resultFormat.setMaxRecords(Integer.MAX_VALUE);
        SimpleDataTable result = new SimpleDataTable(resultFormat);
        LinkedHashSet<DataRecord> records = new LinkedHashSet<DataRecord>();
        for (DataRecord rec : source) {
            records.add(rec);
        }
        for (DataRecord rec : records) {
            DataTableReplication.copyRecord(rec, result.addRecord(), true, true, false, true, null);
        }
        return result;
    }
}

