/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.function.table;

import com.google.common.collect.Lists;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.Function;
import com.tibbo.aggregate.common.expression.ReferenceResolver;
import com.tibbo.aggregate.common.expression.function.AbstractFunction;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class AddColumnsFunction
extends AbstractFunction {
    public AddColumnsFunction() {
        this("addColumns", "DataTable table, String format1, String expression1, String format2, String expression2, ...", Cres.get().getString("fDescAddColumns"));
    }

    public AddColumnsFunction(String name, String parametersFootprint, String description) {
        super(name, Function.GROUP_DATA_TABLE_PROCESSING, parametersFootprint, "DataTable", description);
    }

    @Override
    public Object execute(Evaluator evaluator, EvaluationEnvironment environment, Object ... parameters) throws EvaluationException {
        this.checkParameters(3, true, parameters);
        this.checkParameterType(0, parameters[0], DataTable.class);
        DataTable table = ((DataTable)parameters[0]).clone();
        TableFormat clone = table.getFormat().clone();
        LinkedHashMap<FieldFormat, Expression> newFields = new LinkedHashMap<FieldFormat, Expression>();
        for (int i = 1; i < parameters.length - 1; i += 2) {
            FieldFormat ff = FieldFormat.create(parameters[i].toString());
            clone.addField(ff);
            newFields.put(ff, new Expression(parameters[i + 1].toString()));
        }
        return this.processAddColumns(evaluator, environment, table, clone, newFields, false);
    }

    protected DataTable processAddColumns(Evaluator evaluator, EvaluationEnvironment environment, DataTable table, TableFormat clone, Map<FieldFormat, Expression> newFields, boolean concurrent) throws EvaluationException {
        table.setFormat(clone);
        table.joinFormats();
        for (Map.Entry<FieldFormat, Expression> entry : newFields.entrySet()) {
            ArrayList tasks = Lists.newArrayList();
            int j = 0;
            while (j < table.getRecordCount()) {
                int finalJ = j++;
                tasks.add(() -> {
                    ReferenceResolver resolver = evaluator.getDefaultResolver();
                    Evaluator localEvaluator = new Evaluator(resolver.getContextManager(), resolver.getDefaultContext(), table, resolver.getCallerController());
                    localEvaluator.getEnvironmentResolver().setEnvironment(evaluator.getEnvironmentResolver().getEnvironment());
                    for (Map.Entry<String, ReferenceResolver> e : evaluator.getResolvers().entrySet()) {
                        if (e.getKey() == null) continue;
                        localEvaluator.setResolver(e.getKey(), e.getValue());
                    }
                    localEvaluator.getDefaultResolver().setDefaultRow(finalJ);
                    EvaluationEnvironment eClone = environment.clone();
                    if (eClone.getCause() != null) {
                        eClone.getCause().setRow(null);
                    }
                    try {
                        Object value = localEvaluator.evaluate((Expression)entry.getValue(), eClone);
                        DataRecord rec = table.getRecord(finalJ);
                        rec.setValue(((FieldFormat)entry.getKey()).getName(), value);
                        return null;
                    }
                    catch (SyntaxErrorException ex) {
                        throw new EvaluationException(ex);
                    }
                });
            }
            this.executeTasks(tasks, evaluator.getExecutorService(), concurrent);
        }
        return table;
    }
}

