/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.function.table;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.function.table.AddColumnsFunction;
import java.util.LinkedHashMap;

public class AddColumnsExFunction
extends AddColumnsFunction {
    public AddColumnsExFunction() {
        super("addColumnsEx", "DataTable table, DataTable columns, boolean concurrent", Cres.get().getString("fDescAddColumnsEx"));
    }

    @Override
    public Object execute(Evaluator evaluator, EvaluationEnvironment environment, Object ... parameters) throws EvaluationException {
        this.checkParameters(3, true, parameters);
        this.checkParameterType(0, parameters[0], DataTable.class);
        DataTable table = ((DataTable)parameters[0]).clone();
        this.checkParameterType(0, parameters[1], DataTable.class);
        DataTable columns = ((DataTable)parameters[1]).clone();
        this.checkParameterType(0, parameters[2], Boolean.class);
        boolean concurrent = (Boolean)parameters[2];
        TableFormat clone = table.getFormat().clone();
        LinkedHashMap<FieldFormat, Expression> newFields = new LinkedHashMap<FieldFormat, Expression>();
        for (DataRecord dataRecord : columns) {
            FieldFormat ff = FieldFormat.create(dataRecord.getValue(0).toString());
            newFields.put(ff, new Expression(dataRecord.getValue(1).toString()));
            clone.addField(ff);
        }
        return this.processAddColumns(evaluator, environment, table, clone, newFields, concurrent);
    }
}

