/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.function.other;

import com.csvreader.CsvReader;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.ExpressionUtils;
import com.tibbo.aggregate.common.expression.Function;
import com.tibbo.aggregate.common.expression.function.AbstractFunction;
import com.tibbo.aggregate.common.util.CsvImportExportUtils;
import com.tibbo.aggregate.common.util.StringUtils;
import java.io.IOException;
import java.text.MessageFormat;

public class TableFromCSVFunction
extends AbstractFunction {
    public TableFromCSVFunction() {
        super("tableFromCSV", Function.GROUP_DATA_TABLE_PROCESSING, "String csv, String header, String delimiter [, String format [, String qualifier [, Integer escapeMode [, String comment]]]]", "DataTable", Cres.get().getString("fDescTableFromCSV"));
    }

    @Override
    public Object execute(Evaluator evaluator, EvaluationEnvironment environment, Object ... parameters) throws EvaluationException {
        this.checkParameters(3, false, parameters);
        try {
            TableFormat format;
            char comment;
            boolean useComments;
            int escapeMode;
            char qualifier;
            boolean useQualifier;
            String text = parameters[0].toString();
            byte[] data = text.getBytes(StringUtils.UTF8_CHARSET);
            String headerType = parameters[1].toString();
            int header = this.getHeaderNumber(headerType);
            String param2 = parameters[2].toString();
            char delimiter = this.getChar(param2, "delimiter");
            if (parameters.length >= 5 && parameters[4] != null) {
                useQualifier = true;
                qualifier = this.getChar(parameters[4].toString(), "qualifier");
            } else {
                useQualifier = false;
                qualifier = '\"';
            }
            if (parameters.length >= 6 && parameters[5] != null) {
                Number escapeModeNumber = (Number)parameters[5];
                escapeMode = escapeModeNumber.intValue();
            } else {
                escapeMode = 2;
            }
            if (parameters.length >= 7 && parameters[6] != null) {
                useComments = true;
                comment = this.getChar(parameters[6].toString(), "comment");
            } else {
                useComments = false;
                comment = '#';
            }
            CsvReader reader = CsvImportExportUtils.createCsvReader(data, delimiter, useQualifier, qualifier, escapeMode, useComments, comment);
            if (header == 3) {
                reader.skipRecord();
            } else if (header == 1 || header == 2) {
                reader.readHeaders();
            }
            if (parameters.length >= 4) {
                this.checkHeader(header, true);
                if (parameters[3] == null) {
                    throw new EvaluationException(MessageFormat.format(Cres.get().getString("exprParamCantBeNull"), 3));
                }
                String formatString = parameters[3].toString();
                format = ExpressionUtils.readFormat(formatString);
            } else {
                this.checkHeader(header, false);
                format = CsvImportExportUtils.readFormat(null, reader, header);
            }
            if (header != 0) {
                this.checkNumberOfColumns(format, reader);
            }
            SimpleDataTable loaded = new SimpleDataTable(format);
            boolean hasMoreRecords = reader.readRecord();
            CsvImportExportUtils.readCsvRecords(loaded, reader, header, hasMoreRecords);
            reader.close();
            return loaded;
        }
        catch (Exception ex) {
            throw new EvaluationException(ex.getMessage(), ex);
        }
    }

    private char getChar(String str, String parameterDescription) throws EvaluationException {
        if (str.length() != 1) {
            throw new EvaluationException("The " + parameterDescription + " must be a one-character string. Received: \"" + str.replace("\\", "\\\\") + "\".");
        }
        return str.charAt(0);
    }

    private int getHeaderNumber(String headerType) throws UnsupportedOperationException {
        int header;
        switch (headerType) {
            case "none": {
                header = 0;
                break;
            }
            case "names": {
                header = 1;
                break;
            }
            case "descriptions": {
                header = 2;
                break;
            }
            case "skip": {
                header = 3;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Header of type \"" + headerType + "\" is not supported.");
            }
        }
        return header;
    }

    private void checkHeader(int header, boolean isFormatProvided) throws EvaluationException {
        if (isFormatProvided) {
            if (header == 1 || header == 2) {
                throw new EvaluationException("If format is specified the header type must be either \"none\" or \"skip\" and cannot be \"names\" or \"descriptions\".");
            }
        } else if (header == 0) {
            throw new EvaluationException("If the header type is \"none\" the table format must be specified using the format parameter.");
        }
    }

    private void checkNumberOfColumns(TableFormat format, CsvReader reader) throws EvaluationException, IOException {
        int numberOfColumnsInFormat;
        int actualNumberOfColumns = reader.getHeaders() != null ? reader.getHeaderCount() : reader.getColumnCount();
        if (actualNumberOfColumns != (numberOfColumnsInFormat = format.getFieldCount())) {
            throw new EvaluationException("The number of columns in the specified format does not match the number of columns in the csv file content.");
        }
    }
}

