/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.function;

import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.function.AbstractFunction;
import com.tibbo.aggregate.common.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;

public class JavaMethodFunction
extends AbstractFunction {
    private static final Class[][] CONVERSIONS = new Class[][]{{Float.TYPE, Double.TYPE}, {Float.TYPE, Double.class}, {Float.class, Double.TYPE}, {Float.class, Double.class}, {Double.TYPE, Double.TYPE}, {Double.TYPE, Double.class}, {Double.class, Double.TYPE}, {Double.class, Double.class}, {Character.class, Character.TYPE}, {Character.TYPE, Character.class}, {String.class, CharSequence.class}};
    private final String name;
    private final String clazz;
    private final String method;
    private final boolean statical;

    public JavaMethodFunction(String clazz, String name, String method, String category, String parametersFootprint, String returnValue, String description) {
        this(clazz, name, method, true, category, parametersFootprint, returnValue, description);
    }

    public JavaMethodFunction(String clazz, String name, String method, String category, String parametersFootprint, String returnValue) {
        this(clazz, name, method, true, category, parametersFootprint, returnValue, null);
    }

    public JavaMethodFunction(String clazz, String name, String method, boolean statical, String category, String parametersFootprint, String returnValue) {
        this(clazz, name, method, statical, category, parametersFootprint, returnValue, null);
    }

    public JavaMethodFunction(String clazz, String name, String method, boolean statical, String category, String parametersFootprint, String returnValue, String description) {
        super(name, category, parametersFootprint, returnValue, description);
        this.name = name;
        this.clazz = clazz;
        this.method = method;
        this.statical = statical;
    }

    @Override
    public Object execute(Evaluator evaluator, EvaluationEnvironment environment, Object ... parameters) throws EvaluationException {
        try {
            Class<?> cls = Class.forName(this.clazz);
            Object instance = null;
            if (!this.statical) {
                instance = this.convertInstance(cls, parameters[0]);
                Object[] np = new Object[parameters.length - 1];
                System.arraycopy(parameters, 1, np, 0, parameters.length - 1);
                parameters = np;
            }
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = this.convertParameter(i, parameters[i]);
            }
            Class[] types = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                types[i] = parameters[i] != null ? parameters[i].getClass() : null;
            }
            Method executor = this.findExecutorMethod(cls, types, 0);
            if (executor == null) {
                Method[] classMethods;
                for (Method cur : classMethods = cls.getMethods()) {
                    if (!cur.getName().equals(this.method) || cur.getParameterTypes().length != types.length) continue;
                    executor = cur;
                    break;
                }
            }
            if (executor == null) {
                throw new EvaluationException("Incompatible arguments");
            }
            this.castTypes(executor.getParameterTypes(), parameters);
            if (instance == null && !this.statical) {
                throw new EvaluationException("Object cannot be null");
            }
            return executor.invoke(instance, parameters);
        }
        catch (InvocationTargetException ex) {
            throw new EvaluationException(ex.getTargetException().getMessage(), ex.getTargetException());
        }
        catch (Exception ex) {
            throw new EvaluationException(ex);
        }
    }

    private Object convertInstance(Class cls, Object instance) {
        if (instance == null) {
            return null;
        }
        if (cls.isAssignableFrom(instance.getClass())) {
            return instance;
        }
        if (cls == String.class) {
            return instance.toString();
        }
        if (cls == Date.class) {
            return Util.convertToDate(instance, false, false);
        }
        return instance;
    }

    private Method findExecutorMethod(Class cls, Class[] types, int firstParameterToRotate) {
        try {
            return cls.getMethod(this.method, types);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            for (int i = firstParameterToRotate; i < types.length; ++i) {
                Class original = types[i];
                for (Class[] conversions : CONVERSIONS) {
                    if (original != conversions[0]) continue;
                    types[i] = conversions[1];
                    try {
                        return cls.getMethod(this.method, types);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        Method executor = this.findExecutorMethod(cls, types, firstParameterToRotate + 1);
                        if (executor == null) continue;
                        return executor;
                    }
                }
                types[i] = original;
            }
            return null;
        }
    }

    private void castTypes(Class[] types, Object[] parameters) {
        for (int i = 0; i < types.length; ++i) {
            Class<?> currentType;
            Class requiredType = types[i];
            Class<?> clazz = currentType = parameters[i] != null ? parameters[i].getClass() : null;
            if (requiredType.equals(currentType) || parameters[i] == null) continue;
            if (parameters[i] instanceof DataTable && ((DataTable)parameters[i]).isOneCellTable()) {
                parameters[i] = ((DataTable)parameters[i]).get();
            }
            if (requiredType == Integer.class || requiredType == Integer.TYPE) {
                parameters[i] = parameters[i] instanceof Number ? ((Number)parameters[i]).intValue() : new Integer(parameters[i].toString()).intValue();
                continue;
            }
            if (requiredType == Long.class || requiredType == Long.TYPE) {
                parameters[i] = parameters[i] instanceof Number ? ((Number)parameters[i]).longValue() : new Long(parameters[i].toString()).longValue();
                continue;
            }
            if (requiredType == Float.class || requiredType == Float.TYPE) {
                parameters[i] = Float.valueOf(parameters[i] instanceof Number ? ((Number)parameters[i]).floatValue() : new Float(parameters[i].toString()).floatValue());
                continue;
            }
            if (requiredType == Double.class || requiredType == Double.TYPE) {
                parameters[i] = parameters[i] instanceof Number ? ((Number)parameters[i]).doubleValue() : new Double(parameters[i].toString()).doubleValue();
                continue;
            }
            if (requiredType != String.class) continue;
            parameters[i] = parameters[i].toString();
        }
    }

    protected Object convertParameter(int i, Object value) {
        return value;
    }
}

