/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.function;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.field.StringFieldFormat;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Function;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.function.AbstractFunction;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class ExpressionEditorOptionsFunction
extends AbstractFunction {
    public ExpressionEditorOptionsFunction() {
        super("expressionEditorOptions", Function.GROUP_SYSTEM, null, "String", "");
    }

    @Override
    public Object execute(Evaluator evaluator, EvaluationEnvironment environment, Object ... parameters) throws EvaluationException {
        DataTable defaultTable;
        LinkedHashMap<Reference, String> references;
        Context defaultContext;
        block19: {
            this.checkParameters(1, true, parameters);
            CallerController caller = evaluator.getDefaultResolver().getCallerController();
            ContextManager contextManager = evaluator.getDefaultResolver().getContextManager();
            String defaultContextMask = parameters[0] != null ? parameters[0].toString() : null;
            defaultContext = null;
            List<Object> contexts = new LinkedList();
            if (defaultContextMask != null && contextManager != null) {
                contexts = ContextUtils.expandMaskToContexts(defaultContextMask, contextManager, caller);
            }
            if (contexts.size() == 1) {
                defaultContext = (Context)contexts.get(0);
            }
            references = new LinkedHashMap<Reference, String>();
            String entity = parameters.length >= 3 && parameters[1] != null ? parameters[1].toString() : null;
            Integer entityType = parameters.length >= 3 && parameters[2] != null ? Integer.valueOf(parameters[2].toString()) : null;
            defaultTable = null;
            DataTable additionalReferences = null;
            if (parameters.length >= 4 && parameters[3] != null && parameters[3] instanceof DataTable) {
                additionalReferences = (DataTable)parameters[3];
            }
            if (additionalReferences != null) {
                for (Object rec : additionalReferences) {
                    references.put(new Reference(((DataRecord)rec).getString("reference")), ((DataRecord)rec).getString("description"));
                }
            }
            try {
                if (entity == null || entityType == null || contextManager == null) break block19;
                Object utilitiesContext = contextManager.get("utilities", caller);
                switch (entityType) {
                    case 1: {
                        Object refs;
                        for (Context context : contexts) {
                            if (context.getVariableDefinition(entity, caller) == null) continue;
                            defaultContext = context;
                            defaultTable = defaultContext.getVariable(entity, caller);
                        }
                        if (defaultContextMask != null && utilitiesContext != null) {
                            refs = utilitiesContext.callFunction("variableFields", caller, defaultContextMask, entity);
                            Iterator<DataRecord> iterator = refs.iterator();
                            while (iterator.hasNext()) {
                                DataRecord rec = iterator.next();
                                references.put(new Reference(rec.getString("reference")), rec.getString("description"));
                            }
                        }
                        break;
                    }
                    case 2: {
                        for (Context iterator : contexts) {
                            if (iterator.getFunctionDefinition(entity, caller) == null) continue;
                            defaultContext = iterator;
                            defaultTable = new SimpleDataTable(defaultContext.getFunctionDefinition(entity).getInputFormat(), true);
                        }
                        break;
                    }
                    case 4: {
                        Object refs;
                        for (Context context : contexts) {
                            if (context.getEventDefinition(entity, caller) == null) continue;
                            defaultContext = context;
                            defaultTable = new SimpleDataTable(defaultContext.getEventDefinition(entity).getFormat(), true);
                        }
                        if (defaultContextMask != null && utilitiesContext != null) {
                            refs = utilitiesContext.callFunction("eventFields", caller, defaultContextMask, entity);
                            Iterator<DataRecord> iterator = refs.iterator();
                            while (iterator.hasNext()) {
                                DataRecord rec = iterator.next();
                                references.put(new Reference(rec.getString("reference")), rec.getString("description"));
                            }
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown entity type: " + entityType);
                    }
                }
            }
            catch (ContextException ex) {
                throw new EvaluationException(ex);
            }
        }
        return StringFieldFormat.encodeExpressionEditorOptions(defaultContext, defaultTable, references);
    }
}

