/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.function;

import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.function.AbstractFunction;
import java.text.MessageFormat;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;

public abstract class AbstractSingleValueCollectorFunction
extends AbstractFunction {
    protected final AbstractStorelessUnivariateStatistic collector;
    private final ReentrantLock collectorLock = new ReentrantLock();

    public AbstractSingleValueCollectorFunction(@Nullable AbstractStorelessUnivariateStatistic collector, String name, String category, String parametersFootprint, String returnValue, String description) {
        super(name, category, parametersFootprint, returnValue, description);
        this.collector = collector;
    }

    protected Object compare(Number first, Number second) {
        throw new RuntimeException(MessageFormat.format("Comparison of 2 arguments is not implemented for \"{0}\" function", this.getName()));
    }

    @Override
    public Object execute(Evaluator evaluator, EvaluationEnvironment environment, Object ... parameters) throws EvaluationException {
        if (parameters.length == 2 && parameters[0] instanceof Number && parameters[1] instanceof Number) {
            return this.compare((Number)parameters[0], (Number)parameters[1]);
        }
        this.checkParameters(1, false, parameters);
        this.checkParameterType(0, parameters[0], DataTable.class);
        DataTable table = (DataTable)parameters[0];
        if (table.getRecordCount() == 0) {
            return 0.0;
        }
        FieldFormat ff = table.getFormat(0);
        if (parameters.length >= 2) {
            ff = this.checkAndGetNumericTypeField(table, parameters[1]);
        } else {
            this.checkNumericTypeField(ff);
        }
        return this.collect(table, ff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object collect(DataTable table, FieldFormat ff) throws EvaluationException {
        if (this.collector == null) {
            throw new EvaluationException("No collector is set");
        }
        this.collectorLock.lock();
        try {
            this.collector.clear();
            Function<Number, Double> toDoubleConverter = AbstractSingleValueCollectorFunction.getDoubleConvert(ff.getType());
            String fieldName = ff.getName();
            table.forEach(rec -> {
                Object value = rec.getValue(fieldName);
                if (value != null) {
                    this.collector.increment(((Double)toDoubleConverter.apply((Number)value)).doubleValue());
                }
            });
            Double d = this.collector.getResult();
            return d;
        }
        finally {
            this.collectorLock.unlock();
        }
    }

    private static Function<Number, Double> getDoubleConvert(char entityType) {
        switch (entityType) {
            case 'I': {
                return value -> value.intValue();
            }
            case 'L': {
                return value -> value.longValue();
            }
            case 'F': {
                return value -> Double.valueOf(value.toString());
            }
            case 'E': {
                return value -> value.doubleValue();
            }
        }
        throw new IllegalStateException("Expected numeric type, got: " + entityType);
    }

    protected double[] toArray(DataTable table, FieldFormat ff) {
        String field = ff.getName();
        double[] data = new double[table.getRecordCount().intValue()];
        int i = 0;
        Function<Number, Double> toDoubleConverter = AbstractSingleValueCollectorFunction.getDoubleConvert(ff.getType());
        for (DataRecord rec : table) {
            Object value = rec.getValue(field);
            if (value == null) continue;
            data[i++] = toDoubleConverter.apply((Number)value);
        }
        return data;
    }
}

