/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression.function;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.expression.AttributedObject;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.ExpressionUtils;
import com.tibbo.aggregate.common.expression.Function;
import com.tibbo.aggregate.common.expression.ReferenceResolver;
import com.tibbo.aggregate.common.util.Pair;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;

public abstract class AbstractFunction
implements Function {
    private final String name;
    private final String parametersFootprint;
    private final String category;
    private final String returnValue;
    private final String description;

    public AbstractFunction(String name, String category, String parametersFootprint, String returnValue, String description) {
        this.name = name;
        this.category = category;
        this.parametersFootprint = parametersFootprint;
        this.returnValue = returnValue;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getReturnValue() {
        return this.returnValue;
    }

    @Override
    public String getParametersFootprint() {
        return this.parametersFootprint;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void checkParameters(int minimalCount, boolean allowNulls, Object ... parameters) throws EvaluationException {
        if (parameters.length < minimalCount) {
            throw new EvaluationException(MessageFormat.format(Cres.get().getString("exprInvalidParamCount"), minimalCount, parameters.length));
        }
        if (!allowNulls) {
            for (int i = 0; i < minimalCount; ++i) {
                if (parameters[i] != null) continue;
                throw new EvaluationException(MessageFormat.format(Cres.get().getString("exprParamCantBeNull"), i));
            }
        }
    }

    protected void checkParameterType(int num, Object value, Class requiredType) throws EvaluationException {
        if (value == null) {
            throw new EvaluationException(MessageFormat.format(Cres.get().getString("exprInvalidParameterType"), num, requiredType.getSimpleName(), "NULL"));
        }
        if (!requiredType.isAssignableFrom(value.getClass())) {
            throw new EvaluationException(MessageFormat.format(Cres.get().getString("exprInvalidParameterType"), num, requiredType.getSimpleName(), value.getClass().getSimpleName()));
        }
    }

    protected FieldFormat checkAndGetNumericTypeField(@Nonnull DataTable table, @Nonnull Object fieldParam) throws EvaluationException {
        FieldFormat ff;
        if (fieldParam instanceof Number) {
            Number fieldIndex = (Number)fieldParam;
            if (fieldIndex.intValue() >= table.getFieldCount()) {
                throw new EvaluationException(Cres.get().getString("exprTableHasNoFieldIndex") + fieldIndex.intValue());
            }
            ff = table.getFormat(fieldIndex.intValue());
        } else {
            ff = table.getFormat(fieldParam.toString());
            if (ff == null) {
                throw new EvaluationException(Cres.get().getString("exprTableHasNoField") + fieldParam);
            }
        }
        this.checkNumericTypeField(ff);
        return ff;
    }

    protected void checkNumericTypeField(@Nonnull FieldFormat ff) throws EvaluationException {
        if (!FieldFormat.isNumericField(ff)) {
            throw new EvaluationException(MessageFormat.format(Cres.get().getString("exprInvalidParameterType"), ff.getName(), "Number", Character.valueOf(ff.getType())));
        }
    }

    @Override
    public AttributedObject executeAttributed(Evaluator evaluator, EvaluationEnvironment environment, AttributedObject ... parameters) throws EvaluationException {
        Object[] convertedParameters = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            convertedParameters[i] = ExpressionUtils.getValue(parameters[i]);
        }
        return ExpressionUtils.toAttributed(this.execute(evaluator, environment, convertedParameters));
    }

    protected void executeTasks(List<Callable<Void>> tasks, ExecutorService executorService, boolean executeConcurrent) throws EvaluationException {
        block7: {
            try {
                if (executeConcurrent && executorService != null) {
                    try {
                        List<Future<Void>> futures = executorService.invokeAll(tasks);
                        for (Future<Void> future : futures) {
                            future.get();
                        }
                        break block7;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new EvaluationException(e);
                    }
                }
                for (Callable<Void> task : tasks) {
                    task.call();
                }
            }
            catch (Exception ex) {
                throw new EvaluationException(ex);
            }
        }
    }

    protected Pair<Context, CallerController> resolveContext(String contextPath, Evaluator evaluator) throws EvaluationException {
        ReferenceResolver resolver;
        ContextManager cm;
        Object con = null;
        CallerController callerController = null;
        Iterator<ReferenceResolver> iterator = evaluator.getResolvers().values().iterator();
        while (iterator.hasNext() && ((cm = (resolver = iterator.next()).getContextManager()) == null || (con = (Object)cm.get(contextPath, callerController = resolver.getCallerController())) == null)) {
        }
        if (con == null) {
            throw new EvaluationException(String.format("%s %s", Cres.get().getString("conNotAvail"), contextPath));
        }
        return new Pair<Object, Object>(con, callerController);
    }

    protected Pair<Context, CallerController> resolveContext(String contextPath, String schema, Evaluator evaluator) throws EvaluationException {
        ReferenceResolver resolver = evaluator.getResolver(schema);
        ContextManager cm = resolver.getContextManager();
        CallerController callerController = resolver.getCallerController();
        if (cm == null) {
            throw new EvaluationException(String.format("%s %s", Cres.get().getString("conNotAvail"), contextPath));
        }
        Object con = cm.get(contextPath, callerController);
        if (con != null) {
            return new Pair<Context, CallerController>((Context)con, callerController);
        }
        throw new EvaluationException(String.format("%s %s", Cres.get().getString("conNotAvail"), contextPath));
    }
}

