/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression;

import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.ExpressionUtils;
import com.tibbo.aggregate.common.util.CloneUtils;
import com.tibbo.aggregate.common.util.Pair;
import com.tibbo.aggregate.common.util.PublicCloneable;
import com.tibbo.aggregate.common.util.StringUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Reference
implements Cloneable,
PublicCloneable {
    public static final String SCHEMA_FORM = "form";
    public static final String SCHEMA_WEB = "web";
    public static final String SCHEMA_TABLE = "table";
    public static final String SCHEMA_STATISTICS = "statistics";
    public static final String SCHEMA_GRANULATION = "granulation";
    public static final String SCHEMA_ENVIRONMENT = "env";
    public static final String SCHEMA_PARENT = "parent";
    public static final String SCHEMA_MENU = "menu";
    public static final String SCHEMA_ACTION = "action";
    public static final char EVENT_SIGN = '@';
    public static final char ACTION_SIGN = '!';
    public static final char PARAMS_BEGIN = '(';
    public static final char PARAMS_END = ')';
    public static final char SCHEMA_END = '/';
    public static final char SERVER_END = '^';
    public static final char CONTEXT_END = ':';
    public static final char FIELD_BEGIN = '$';
    public static final char FIELD_SEPARATOR = '.';
    public static final char ROW_BEGIN = '[';
    public static final char ROW_END = ']';
    public static final char PROPERTY_BEGIN = '#';
    public static final Integer APPEARANCE_LINK = 1;
    public static final Integer APPEARANCE_BUTTON = 2;
    private String image;
    private String schema;
    private String server;
    private String context;
    private String entity;
    private int entityType = 1;
    private List<Object> parameters = new LinkedList<Object>();
    private List<Pair<String, Integer>> fields = new LinkedList<Pair<String, Integer>>();
    private String property;
    private Integer appearance = APPEARANCE_LINK;

    public Reference() {
    }

    public Reference(String source) {
        this.parse(source);
    }

    public Reference(String server, String context) {
        this.server = server;
        this.context = context;
    }

    public Reference(String entity, int entityType) {
        this.entity = entity;
        this.entityType = entityType;
    }

    public Reference(String entity, int entityType, String field) {
        this.entity = entity;
        this.entityType = entityType;
        this.fields.add(new Pair<String, Object>(field, null));
    }

    public Reference(String entity, int entityType, String field, int line) {
        this.entity = entity;
        this.entityType = entityType;
        this.fields.add(new Pair<String, Integer>(field, line));
    }

    public Reference(String context, String entity, int entityType, String field) {
        this(entity, entityType, field);
        this.context = context;
    }

    public Reference(String context, String entity, int entityType) {
        this.context = context;
        this.entity = entity;
        this.entityType = entityType;
    }

    public Reference(String context, String function, Object[] parameters) {
        this.context = context;
        this.entity = function;
        this.entityType = 2;
        Collections.addAll(this.parameters, parameters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parse(String source) {
        int fieldBegin;
        int propertyBegin;
        int contextEnd;
        int serverEnd;
        source = source.trim();
        boolean isFunction = false;
        boolean isEvent = false;
        boolean isAction = false;
        String src = this.image = source;
        int paramsBegin = src.indexOf(40);
        int paramsEnd = src.lastIndexOf(41);
        if (paramsBegin != -1) {
            String paramsSrc;
            if (paramsEnd == -1) {
                throw new IllegalArgumentException("No closing ')' for parameters");
            }
            int actionSignPos = src.lastIndexOf(33);
            if (actionSignPos == paramsEnd + 1) {
                isAction = true;
                paramsSrc = src.substring(paramsBegin + 1, paramsEnd);
                this.parameters = ExpressionUtils.getFunctionParameters(paramsSrc, true);
                this.entityType = 8;
                src = src.substring(0, paramsBegin) + src.substring(actionSignPos + 1);
            } else {
                isFunction = true;
                paramsSrc = src.substring(paramsBegin + 1, paramsEnd);
                this.parameters = ExpressionUtils.getFunctionParameters(paramsSrc, true);
                this.entityType = 2;
                src = src.substring(0, paramsBegin) + src.substring(paramsEnd + 1);
            }
        } else {
            int eventSignPos = src.lastIndexOf(64);
            if (eventSignPos != -1) {
                isEvent = true;
                this.entityType = 4;
                src = src.substring(0, eventSignPos) + src.substring(eventSignPos + 1);
            } else {
                int actionSignPos = src.lastIndexOf(33);
                if (actionSignPos != -1) {
                    isAction = true;
                    this.entityType = 8;
                    src = src.substring(0, actionSignPos) + src.substring(actionSignPos + 1);
                }
            }
        }
        int schemaEnd = src.indexOf(47);
        if (schemaEnd != -1) {
            this.schema = src.substring(0, schemaEnd);
            src = src.substring(schemaEnd + 1);
        }
        if ((serverEnd = src.indexOf(94)) != -1) {
            this.server = src.substring(0, serverEnd);
            src = src.substring(serverEnd + 1);
        }
        if ((contextEnd = src.indexOf(58)) != -1) {
            this.context = src.substring(0, contextEnd);
            src = src.substring(contextEnd + 1);
        }
        if ((propertyBegin = src.indexOf(35)) != -1) {
            this.property = src.substring(propertyBegin + 1);
            src = src.substring(0, propertyBegin);
        }
        if ((fieldBegin = src.indexOf(36)) != -1) {
            this.entity = src.substring(0, fieldBegin);
            if (fieldBegin == src.length() - 1) return;
            src = src.substring(fieldBegin + 1);
        } else if (!src.isEmpty() && (this.context != null || isFunction || isEvent || isAction)) {
            this.entity = src;
            return;
        }
        if (src.isEmpty()) {
            return;
        }
        List<String> fieldRefs = StringUtils.split(src, '.');
        Integer row = null;
        for (String fieldRef : fieldRefs) {
            String field;
            int rowBegin = fieldRef.indexOf(91);
            int rowEnd = fieldRef.indexOf(93);
            if (rowBegin != -1) {
                if (rowEnd == -1) {
                    throw new IllegalArgumentException("No closing ']' in row reference");
                }
                row = Integer.valueOf(fieldRef.substring(rowBegin + 1, rowEnd));
                field = fieldRef.substring(0, rowBegin);
            } else {
                field = fieldRef;
            }
            this.fields.add(new Pair<String, Object>(field, row));
            row = null;
        }
    }

    public String getServer() {
        return this.server;
    }

    public String getContext() {
        return this.context;
    }

    public String getEntity() {
        return this.entity;
    }

    public int getEntityType() {
        return this.entityType;
    }

    public String getField() {
        return !this.fields.isEmpty() ? this.fields.get(0).getFirst() : null;
    }

    public List<Pair<String, Integer>> getFields() {
        return this.fields;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public Integer getRow() {
        return !this.fields.isEmpty() ? this.fields.get(0).getSecond() : null;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getProperty() {
        return this.property;
    }

    public String getImage() {
        if (this.image != null) {
            return this.image;
        }
        return this.createImage();
    }

    private String createImage() {
        StringBuilder sb = new StringBuilder();
        if (this.schema != null) {
            sb.append(this.schema);
            sb.append('/');
        }
        if (this.server != null) {
            sb.append(this.server);
            sb.append('^');
        }
        if (this.context != null) {
            sb.append(this.context);
            sb.append(':');
        }
        if (this.entity != null) {
            sb.append(this.entity);
            if (this.entityType == 2) {
                sb.append('(');
                sb.append(ExpressionUtils.getFunctionParameters(this.parameters));
                sb.append(')');
            }
            if (this.entityType == 4) {
                sb.append('@');
            }
            if (this.entityType == 8) {
                if (!this.parameters.isEmpty()) {
                    sb.append('(');
                    sb.append(ExpressionUtils.getFunctionParameters(this.parameters));
                    sb.append(')');
                }
                sb.append('!');
            }
            if (this.entityType == 100 && !this.parameters.isEmpty()) {
                sb.append('(');
                sb.append(ExpressionUtils.getFunctionParameters(this.parameters));
                sb.append(')');
            }
            if (!this.fields.isEmpty() || this.context == null && this.entityType == 1) {
                sb.append('$');
            }
        }
        int i = 0;
        for (Pair<String, Integer> field : this.fields) {
            if (i > 0) {
                sb.append('.');
            }
            if (field.getFirst() != null) {
                sb.append(field.getFirst());
            }
            if (field.getSecond() != null) {
                sb.append('[');
                sb.append(field.getSecond());
                sb.append(']');
            }
            ++i;
        }
        if (this.property != null) {
            sb.append('#');
            sb.append(this.property);
        }
        this.image = sb.toString();
        return this.image;
    }

    public String toString() {
        return this.getImage();
    }

    public void setContext(String context) {
        this.context = context;
        this.image = null;
    }

    public void setEntity(String entity) {
        this.entity = entity;
        this.image = null;
    }

    public void setEntityType(int entityType) {
        this.entityType = entityType;
        this.image = null;
    }

    public void addParameter(String parameter) {
        this.parameters.add(parameter);
        this.image = null;
    }

    public void addParameter(Expression parameter) {
        this.parameters.add(parameter);
        this.image = null;
    }

    public void setField(String field) {
        if (this.fields.isEmpty()) {
            this.fields.add(new Pair<String, Object>(field, null));
        } else {
            this.fields.get(0).setFirst(field);
        }
        this.image = null;
    }

    public void setFields(List<Pair<String, Integer>> fields) {
        this.fields = fields;
        this.image = null;
    }

    public void addField(String field) {
        this.fields.add(new Pair<String, Object>(field, null));
        this.image = null;
    }

    public void addField(String field, Integer record) {
        this.fields.add(new Pair<String, Integer>(field, record));
        this.image = null;
    }

    public void setProperty(String property) {
        this.property = property;
        this.image = null;
    }

    public void setSchema(String schema) {
        this.schema = schema;
        this.image = null;
    }

    public void setRow(Integer row) {
        if (this.fields.isEmpty()) {
            this.fields.add(new Pair<Object, Integer>(null, row));
        } else {
            this.fields.get(0).setSecond(row);
        }
        this.image = null;
    }

    public void setServer(String server) {
        this.server = server;
        this.image = null;
    }

    @Override
    public Reference clone() {
        try {
            Reference cl = (Reference)super.clone();
            cl.fields = (List)CloneUtils.deepClone(this.fields);
            return cl;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public boolean equals(Object obj) {
        boolean isReferenceNotNull = obj instanceof Reference;
        return isReferenceNotNull && this.getImage().equals(((Reference)obj).getImage());
    }

    public int hashCode() {
        return this.getImage().hashCode();
    }

    public Integer getAppearance() {
        return this.appearance;
    }

    public void setAppearance(Integer appearance) {
        this.appearance = appearance;
    }
}

