/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.ExpressionUtils;
import com.tibbo.aggregate.common.expression.parser.ASTStart;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class ParsedExpressionCache {
    private static final LoadingCache<String, ASTStart> PARSE_CACHE = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(25L, TimeUnit.HOURS).recordStats().build((CacheLoader)new CacheLoader<String, ASTStart>(){

        public ASTStart load(@Nonnull String expressionText) throws Exception {
            ASTStart astStart = ExpressionUtils.parse(expressionText, true);
            Evaluator.EvaluationStatistics.onExpressionParsed();
            return astStart;
        }
    });

    public static ASTStart getCachedAstRoot(String expressionText) throws SyntaxErrorException {
        try {
            return (ASTStart)PARSE_CACHE.getUnchecked((Object)expressionText);
        }
        catch (ExecutionError | UncheckedExecutionException e) {
            if (e.getCause() instanceof SyntaxErrorException) {
                throw (SyntaxErrorException)e.getCause();
            }
            throw e;
        }
    }
}

