/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression;

import com.google.common.base.Preconditions;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.parser.ASTStart;
import com.tibbo.aggregate.common.structure.Pinpoint;
import com.tibbo.aggregate.common.structure.PinpointAware;
import com.tibbo.aggregate.common.util.PublicCloneable;
import java.util.Optional;
import javax.annotation.Nullable;

public class Expression
implements Cloneable,
PublicCloneable,
PinpointAware {
    public static final String REFERENCE_START = "{";
    public static final String REFERENCE_END = "}";
    private final String text;
    private transient ASTStart rootNode;
    @Nullable
    private transient Pinpoint pinpoint = null;

    public Expression(Reference reference) {
        this(REFERENCE_START + reference.getImage() + REFERENCE_END);
    }

    public Expression(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public ASTStart getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(ASTStart rootNode) {
        this.rootNode = rootNode;
    }

    public String toString() {
        return this.text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Expression other = (Expression)obj;
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    @Override
    public Expression clone() {
        try {
            return (Expression)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    @Override
    public void assignPinpoint(Pinpoint pinpoint) {
        Preconditions.checkState((this.pinpoint == null ? 1 : 0) != 0, (String)"This '%s' already contains pinpoint '%s' but somebody attempted to assign another one: '%s'", (Object)this, (Object)this.pinpoint, (Object)pinpoint);
        this.pinpoint = pinpoint;
    }

    @Override
    public Optional<Pinpoint> obtainPinpoint() {
        return Optional.ofNullable(this.pinpoint);
    }
}

