/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression;

import com.google.common.base.Preconditions;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.ReferenceResolver;
import com.tibbo.aggregate.common.expression.parser.NodeEvaluationDetails;
import com.tibbo.aggregate.common.structure.Pinpoint;
import com.tibbo.aggregate.common.structure.PinpointAware;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class EvaluationEnvironment
implements Cloneable,
PinpointAware {
    private Reference cause;
    private Map<String, Object> environment;
    @Nullable
    private Pinpoint pinpoint;
    private final Map<String, ReferenceResolver> customResolvers = new HashMap<String, ReferenceResolver>();
    private final ThreadLocal<Boolean> debug = new ThreadLocal();
    private final ThreadLocal<NodeEvaluationDetails> rootNode = new ThreadLocal();
    private final ThreadLocal<NodeEvaluationDetails> activeNode = new ThreadLocal();

    public EvaluationEnvironment() {
    }

    public EvaluationEnvironment(ReferenceResolver customDefaultReferenceResolver) {
        this.customResolvers.put(Evaluator.DEFAULT_RESOLVER_KEY, customDefaultReferenceResolver);
    }

    public EvaluationEnvironment(Reference cause) {
        this.cause = cause;
    }

    public EvaluationEnvironment(Map<String, Object> environment) {
        this.environment = environment;
    }

    public EvaluationEnvironment(Reference cause, Map<String, Object> environment) {
        this.cause = cause;
        this.environment = environment;
    }

    public Reference getCause() {
        return this.cause;
    }

    public void setCause(Reference cause) {
        this.cause = cause;
    }

    public Map<String, Object> getEnvironment() {
        if (this.environment == null) {
            this.environment = new HashMap<String, Object>();
        }
        return this.environment;
    }

    public void setEnvironment(Map<String, Object> environment) {
        this.environment = environment;
    }

    public EvaluationEnvironment clone() {
        try {
            EvaluationEnvironment cloneEnv = (EvaluationEnvironment)super.clone();
            if (this.cause != null) {
                cloneEnv.cause = this.cause.clone();
            }
            if (this.pinpoint != null) {
                cloneEnv.pinpoint = this.pinpoint.copy();
            }
            cloneEnv.customResolvers.clear();
            return cloneEnv;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setActiveNode(NodeEvaluationDetails ed) {
        if (this.rootNode.get() == null) {
            this.rootNode.set(ed);
        }
        this.activeNode.set(ed);
    }

    public NodeEvaluationDetails getRootNode() {
        return this.rootNode.get();
    }

    public NodeEvaluationDetails getActiveNode() {
        return this.activeNode.get();
    }

    public void setDebug(boolean debug) {
        this.debug.set(debug);
    }

    public boolean isDebug() {
        Boolean isDebug = this.debug.get();
        return isDebug != null && isDebug != false;
    }

    public Map<String, ReferenceResolver> getCustomResolvers() {
        return this.customResolvers;
    }

    public void addCustomDefaultResolver(ReferenceResolver resolver) {
        this.customResolvers.put(Evaluator.DEFAULT_RESOLVER_KEY, resolver);
    }

    @Override
    public void assignPinpoint(Pinpoint pinpoint) {
        Preconditions.checkState((this.pinpoint == null ? 1 : 0) != 0, (String)"This '%s' already contains pinpoint '%s' but somebody attempted to assign another one: '%s'", (Object)this, (Object)this.pinpoint, (Object)pinpoint);
        this.pinpoint = pinpoint;
    }

    @Override
    public Optional<Pinpoint> obtainPinpoint() {
        return Optional.ofNullable(this.pinpoint);
    }

    @Override
    public void removePinpoint() {
        this.pinpoint = null;
    }
}

