/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.expression.AbstractReferenceResolver;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.util.HashMap;
import java.util.Map;

public class EnvironmentReferenceResolver
extends AbstractReferenceResolver {
    private final Map<String, Object> environment = new HashMap<String, Object>();

    @Override
    public Object resolveReference(Reference ref, EvaluationEnvironment resolvingEnvironment) throws SyntaxErrorException, ContextException, EvaluationException {
        if (!"env".equals(ref.getSchema()) || ref.getServer() != null || ref.getContext() != null || ref.getEntity() != null || ref.getProperty() != null || ref.getRow() != null) {
            throw new EvaluationException("Unexpected reference syntax: " + ref);
        }
        String variable = ref.getField();
        if (resolvingEnvironment != null && resolvingEnvironment.getEnvironment() != null && resolvingEnvironment.getEnvironment().containsKey(variable)) {
            return resolvingEnvironment.getEnvironment().get(variable);
        }
        if (this.environment == null) {
            throw new ContextException(Cres.get().getString("exprEnvNotDefined"));
        }
        if (!this.environment.containsKey(variable)) {
            throw new ContextException(Cres.get().getString("exprEnvVarNotFound") + variable);
        }
        return this.environment.get(variable);
    }

    public void set(String variable, Object value) {
        this.environment.put(variable, value);
    }

    public Object get(String variable) {
        return this.environment.get(variable);
    }

    public void setEnvironment(Map<String, Object> environment) {
        this.environment.putAll(environment);
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }
}

