/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.DefaultRequestController;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableConstruction;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.AbstractReferenceResolver;
import com.tibbo.aggregate.common.expression.DefaultAttributedObject;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.ExpressionUtils;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.resource.ResourceManager;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DefaultReferenceResolver
extends AbstractReferenceResolver {
    public static final String ROW = "row";
    public static final String DESCRIPTION = "description";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String TYPE = "type";
    public static final String READABLE = "readable";
    public static final String WRITABLE = "writable";
    public static final String RECORDS = "records";
    public static final String QUALITY = "quality";
    public static final String TIMESTAMP = "timestamp";
    public static final String FORMAT = "format";
    public static final String HELP = "help";
    public static final String OPTIONS = "options";
    public static final String SELECTION_VALUE_DESCRIPTION = "svdesc";

    public DefaultReferenceResolver() {
    }

    public DefaultReferenceResolver(DataTable defaultTable) {
        this();
        this.setDefaultTable(defaultTable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object resolveReference(Reference ref, EvaluationEnvironment environment) throws SyntaxErrorException, EvaluationException, ContextException {
        boolean notNullDataTable;
        Evaluator.EvaluationStatistics.onReferenceProcessed();
        if (ref.getProperty() != null && ROW.equals(ref.getProperty())) {
            return this.getRow(ref, environment);
        }
        Context con = this.getContext(ref);
        DataTable table = this.getDefaultTable();
        String field = ref.getField();
        if (ref.getEntity() != null) {
            if (con == null) throw new IllegalStateException(MessageFormat.format(Cres.get().getString("exprDefConNotDefined"), ref.getEntity()));
            if (field == null) {
                if (DESCRIPTION.equals(ref.getProperty())) {
                    return this.resolveEntityDescription(ref, con);
                }
                if (ref.getEntityType() == 1) {
                    VariableDefinition vd = con.getVariableDefinition(ref.getEntity());
                    if (vd == null) {
                        throw new IllegalStateException(MessageFormat.format(Cres.get().getString("conVarNotAvailExt"), ref.getEntity(), con.getPath()));
                    }
                    if (READABLE.equals(ref.getProperty())) {
                        return vd.isReadable();
                    }
                    if (WRITABLE.equals(ref.getProperty())) {
                        return vd.isWritable();
                    }
                    if (ICON.equals(ref.getProperty())) {
                        return ResourceManager.getImageIcon(vd.getIconId());
                    }
                }
            } else {
                TableFormat rf;
                if (ref.getEntityType() == 1) {
                    VariableDefinition vd = con.getVariableDefinition(ref.getEntity());
                    if (vd == null) {
                        throw new IllegalStateException(MessageFormat.format(Cres.get().getString("conVarNotAvailExt"), ref.getEntity(), con.getPath()));
                    }
                    rf = vd.getFormat();
                } else {
                    if (ref.getEntityType() != 2) throw new IllegalStateException("Illegal entity type: " + ref.getEntityType());
                    FunctionDefinition fd = con.getFunctionDefinition(ref.getEntity());
                    if (fd == null) {
                        throw new IllegalStateException(MessageFormat.format(Cres.get().getString("conFuncNotAvailExt"), ref.getEntity(), con.getPath()));
                    }
                    rf = fd.getOutputFormat();
                }
                FieldFormat ff = null;
                if (rf != null) {
                    ff = rf.getField(ref.getField());
                }
                if (ff != null) {
                    if (FORMAT.equals(ref.getProperty())) {
                        return ff;
                    }
                    if (DESCRIPTION.equals(ref.getProperty())) {
                        return ff.getDescription();
                    }
                    if (HELP.equals(ref.getProperty())) {
                        return ff.getHelp();
                    }
                }
            }
            table = this.resolveEntity(ref, con, environment);
        } else if (con != null) {
            if (ref.getProperty() != null && ref.getContext() != null) {
                if (NAME.equals(ref.getProperty())) {
                    return con.getName();
                }
                if (DESCRIPTION.equals(ref.getProperty())) {
                    return con.getDescription();
                }
                if (ICON.equals(ref.getProperty())) {
                    return ResourceManager.getImageIcon(con.getIconId());
                }
                if (TYPE.equals(ref.getProperty())) {
                    return con.getType();
                }
            }
            if (ref.getContext() != null) {
                return con.getPath();
            }
        }
        if (table == null) {
            throw new IllegalStateException(MessageFormat.format(Cres.get().getString("exprDefDataTableNotDefined"), field));
        }
        if (field == null && ref.getProperty() != null) {
            if (RECORDS.equals(ref.getProperty())) {
                return table.getRecordCount();
            }
            if (QUALITY.equals(ref.getProperty())) {
                return table.getQuality();
            }
            if (TIMESTAMP.equals(ref.getProperty())) {
                return table.getTimestamp();
            }
        }
        if (field == null) {
            return this.getDefaultTableAggregate(table);
        }
        FieldFormat ff = table.getFormat().getField(ref.getField());
        if (ref.getProperty() != null) {
            if (FORMAT.equals(ref.getProperty())) {
                return ff;
            }
            if (DESCRIPTION.equals(ref.getProperty())) {
                return ff.getDescription();
            }
            if (HELP.equals(ref.getProperty())) {
                return ff.getHelp();
            }
            if (OPTIONS.equals(ref.getProperty())) {
                return ff.getSelectionValues();
            }
        }
        Integer row = this.getRow(ref, environment);
        Object value = ExpressionUtils.findFieldValueByReference(ref, table, row);
        if (ref.getProperty() == null) return new DefaultAttributedObject(value, table.getTimestamp(), table.getQuality());
        if (SELECTION_VALUE_DESCRIPTION.equals(ref.getProperty())) {
            List<Binding> bindings = table.getFormat().getBindings();
            for (int i = bindings.size() - 1; i >= 0; --i) {
                Binding curBinding = bindings.get(i);
                if (curBinding.getTarget() == null || ref.getField() == null || !ref.getField().equals(curBinding.getTarget().getField()) || !"choices".equals(curBinding.getTarget().getProperty())) continue;
                DataTable curBindingExpressionResult = (DataTable)this.getEvaluator().evaluate(curBinding.getExpression(), environment);
                for (DataRecord rec : curBindingExpressionResult) {
                    if (!Objects.equals(value, ff.valueFromString(rec.getValueAsString(0)))) continue;
                    Object valueDesc = rec.getValue(1);
                    return valueDesc == null ? value : valueDesc;
                }
                return value;
            }
            if (ff.hasSelectionValues()) {
                String valueDesc = ff.getSelectionValues().get(value);
                return valueDesc == null ? value : valueDesc;
            }
        }
        if (!(notNullDataTable = value instanceof DataTable)) return new DefaultAttributedObject(value, table.getTimestamp(), table.getQuality());
        DataTable tbl = (DataTable)value;
        if (RECORDS.equals(ref.getProperty())) {
            return tbl.getRecordCount();
        }
        if (QUALITY.equals(ref.getProperty())) {
            return tbl.getQuality();
        }
        if (!TIMESTAMP.equals(ref.getProperty())) return new DefaultAttributedObject(value, table.getTimestamp(), table.getQuality());
        return tbl.getTimestamp();
    }

    protected Object getDefaultTableAggregate(DataTable table) {
        return table;
    }

    protected Integer getRow(Reference ref, EvaluationEnvironment environment) {
        Integer row = ref.getRow();
        if (row != null) {
            return row;
        }
        if (environment != null && environment.getCause() != null && environment.getCause().getRow() != null) {
            row = environment.getCause().getRow();
        } else {
            row = this.getDefaultRow();
            if (row == null) {
                row = 0;
            }
        }
        return row;
    }

    private String resolveEntityDescription(Reference ref, Context con) throws IllegalStateException {
        if (ref.getEntityType() == 1) {
            VariableDefinition vd = con.getVariableDefinition(ref.getEntity());
            if (vd == null) {
                throw new IllegalStateException(MessageFormat.format(Cres.get().getString("conVarNotAvailExt"), ref.getEntity(), con.getPath()));
            }
            return vd.getDescription();
        }
        if (ref.getEntityType() == 2) {
            FunctionDefinition fd = con.getFunctionDefinition(ref.getEntity());
            if (fd == null) {
                throw new IllegalStateException(MessageFormat.format(Cres.get().getString("conFuncNotAvailExt"), ref.getEntity(), con.getPath()));
            }
            return fd.getDescription();
        }
        throw new IllegalStateException("Illegal entity type: " + ref.getEntityType());
    }

    public List<Context> getContexts(Reference ref) throws ContextException {
        if (ref.getContext() != null && ContextUtils.isMask(ref.getContext())) {
            return ContextUtils.expandMaskToContexts(ref.getContext(), this.getContextManager(), this.getCallerController());
        }
        Context con = this.getContext(ref);
        return con != null ? Collections.singletonList(con) : Collections.emptyList();
    }

    public Context getContext(Reference ref) throws ContextException {
        Object con = this.getDefaultContext();
        if (ref.getContext() != null && (con = con != null ? con.get(ref.getContext(), this.getCallerController()) : (this.getContextManager() != null ? this.getContextManager().get(ref.getContext(), this.getCallerController()) : null)) == null) {
            throw new ContextException(Cres.get().getString("conNotAvail") + ref.getContext());
        }
        return con;
    }

    protected DataTable resolveEntity(Reference ref, Context con, EvaluationEnvironment environment) throws ContextException, SyntaxErrorException, EvaluationException {
        if (ref.getEntityType() == 1) {
            VariableDefinition vd = con.getVariableDefinition(ref.getEntity());
            if (vd == null) {
                throw new IllegalStateException(MessageFormat.format(Cres.get().getString("conVarNotAvailExt"), ref.getEntity(), con.getPath()));
            }
            DefaultRequestController requestController = new DefaultRequestController(this.getEvaluator());
            requestController.assignPinpoint(environment.obtainPinpoint());
            return con.getVariable(ref.getEntity(), this.getCallerController(), requestController);
        }
        if (ref.getEntityType() == 2) {
            FunctionDefinition fd = con.getFunctionDefinition(ref.getEntity());
            if (fd == null) {
                throw new IllegalStateException(MessageFormat.format(Cres.get().getString("conFuncNotAvailExt"), ref.getEntity(), con.getPath()));
            }
            DataTable parameters = DataTableConstruction.constructTable(ref.getParameters(), fd.getInputFormat(), this.getEvaluator(), environment);
            DefaultRequestController requestController = new DefaultRequestController(this.getEvaluator());
            requestController.assignPinpoint(environment.obtainPinpoint());
            return con.callFunction(ref.getEntity(), this.getCallerController(), requestController, parameters);
        }
        throw new IllegalStateException("Illegal entity type: " + ref.getEntityType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("(");
        if (this.getDefaultContext() != null) {
            String contextPath = this.getDefaultContext().getPath().equals("") ? "(root)" : this.getDefaultContext().getPath();
            sb.append(" defaultContext='").append(contextPath).append('\'');
        }
        if (this.getDefaultTable() != null) {
            sb.append(" defaultTable='").append(this.getDefaultTable()).append('\'');
        }
        if (this.getDefaultRow() != null) {
            sb.append(" defaultRow=").append(this.getDefaultRow());
        }
        sb.append(" )");
        return sb.toString();
    }
}

