/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.expression;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.expression.AbstractEvaluatingVisitor;
import com.tibbo.aggregate.common.expression.AttributedObject;
import com.tibbo.aggregate.common.expression.EvaluationEnvironment;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.expression.ExpressionUtils;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.expression.ReferenceResolver;
import com.tibbo.aggregate.common.expression.parser.ASTValueReferenceNode;
import com.tibbo.aggregate.common.structure.CallKind;
import com.tibbo.aggregate.common.structure.CallLocation;
import com.tibbo.aggregate.common.structure.Pinpoint;
import java.text.MessageFormat;

public class DefaultEvaluatingVisitor
extends AbstractEvaluatingVisitor {
    public DefaultEvaluatingVisitor(Evaluator evaluator) {
        super(evaluator);
    }

    @Override
    public AttributedObject visit(ASTValueReferenceNode node, EvaluationEnvironment environment) {
        this.describeNode(environment, "{" + node.uriImage + "}");
        if (node.reference == null) {
            node.reference = new Reference(node.uriImage);
        }
        Reference ref = node.reference;
        try {
            ReferenceResolver resolver = environment.getCustomResolvers().get(ref.getSchema());
            if (resolver == null) {
                resolver = this.getEvaluator().getResolver(ref.getSchema());
            }
            if (resolver == null) {
                throw new IllegalStateException(Cres.get().getString("exprNoResolverForSchema") + ref.getSchema());
            }
            environment.obtainPinpoint().ifPresent(pinpoint -> {
                CallLocation callLocation = new CallLocation(CallKind.REFERENCE, node.jjtGetFirstToken().beginLine, node.jjtGetFirstToken().beginColumn, node.uriImage);
                pinpoint.pushLocation(callLocation);
            });
            Object referencedValue = resolver.resolveReference(ref, environment);
            AttributedObject attributedObject = this.set(1, ExpressionUtils.toAttributed(referencedValue));
            return attributedObject;
        }
        catch (Exception ex) {
            throw new IllegalStateException(MessageFormat.format(Cres.get().getString("exprErrResolvingReference"), ref) + ex.getMessage(), ex);
        }
        finally {
            environment.obtainPinpoint().ifPresent(Pinpoint::popLocation);
        }
    }
}

