/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.event;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.AggreGateBean;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.expression.Expression;
import java.util.HashMap;
import java.util.Map;

public class PersistenceBinding
extends AggreGateBean
implements Cloneable {
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_INT = "int";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_TIMESTAMP = "timestamp";
    public static final String TYPE_MATERIALIZED_BLOB = "materialized_blob";
    public static final String TYPE_MATERIALIZED_CLOB = "materialized_clob";
    public static final Map<String, String> CASSANDRA_TYPES = new HashMap<String, String>();
    public static TableFormat FORMAT = new TableFormat();
    private String name;
    private String type;
    private String index;
    private String expression;
    private Expression compiledExpression;

    public PersistenceBinding() {
        super(FORMAT);
    }

    public PersistenceBinding(DataRecord record) {
        super(FORMAT, record);
    }

    public PersistenceBinding(String name, String type, String index, String expression) {
        this();
        if (index != null && index.length() > 2) {
            throw new IllegalStateException("Index name length is limited to 2 characters to meed database name length limitations");
        }
        this.setName(name);
        this.setType(type);
        this.setIndex(index);
        this.setExpression(expression);
    }

    public String getType() {
        return this.type;
    }

    public String getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getExpression() {
        return this.expression;
    }

    public Expression getCompiledExpression() {
        if (this.compiledExpression == null) {
            this.compiledExpression = this.expression != null ? new Expression(this.expression) : null;
        }
        return this.compiledExpression;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.compiledExpression = null;
    }

    public PersistenceBinding clone() {
        try {
            return (PersistenceBinding)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistenceBinding other = (PersistenceBinding)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "PersistenceBinding [name=" + this.name + ", type=" + this.type + ", index=" + this.index + ", expression=" + this.expression + "]";
    }

    static {
        FieldFormat name = FieldFormat.create("<name><S><F=N><D=" + Cres.get().getString("name") + ">");
        FORMAT.addField(name);
        FieldFormat type = FieldFormat.create("<type><S><F=N><D=" + Cres.get().getString("type") + ">");
        type.addSelectionValue(TYPE_BOOLEAN, Cres.get().getString("dtBoolean"));
        type.addSelectionValue(TYPE_STRING, Cres.get().getString("dtString"));
        type.addSelectionValue(TYPE_INT, Cres.get().getString("dtInteger"));
        type.addSelectionValue(TYPE_LONG, Cres.get().getString("dtLong"));
        type.addSelectionValue(TYPE_FLOAT, Cres.get().getString("dtFloat"));
        type.addSelectionValue(TYPE_DOUBLE, Cres.get().getString("dtDouble"));
        type.addSelectionValue(TYPE_TIMESTAMP, Cres.get().getString("date"));
        FORMAT.addField(type);
        FieldFormat index = FieldFormat.create("<index><S><F=N><D=" + Cres.get().getString("index") + ">");
        FORMAT.addField(index);
        FieldFormat expression = FieldFormat.create("<expression><S><F=N><D=" + Cres.get().getString("expression") + "><E=" + "expression" + ">");
        FORMAT.addField(expression);
        CASSANDRA_TYPES.put(TYPE_BOOLEAN, "BooleanType");
        CASSANDRA_TYPES.put(TYPE_STRING, "UTF8Type");
        CASSANDRA_TYPES.put(TYPE_INT, "LongType");
        CASSANDRA_TYPES.put(TYPE_LONG, "LongType");
        CASSANDRA_TYPES.put(TYPE_FLOAT, "FloatType");
        CASSANDRA_TYPES.put(TYPE_DOUBLE, "DoubleType");
        CASSANDRA_TYPES.put(TYPE_TIMESTAMP, "DateType");
    }
}

