/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.event;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.event.EventLevel;
import com.tibbo.aggregate.common.util.Util;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class EventUtils {
    public static final Color COLOR_FATAL = new Color(240, 120, 120);
    public static final Color COLOR_ERROR = new Color(240, 190, 120);
    public static final Color COLOR_WARNING = new Color(240, 240, 120);
    public static final Color COLOR_INFO = new Color(160, 240, 120);
    public static final Color COLOR_NOTICE = new Color(120, 150, 240);
    public static final Color COLOR_NONE = new Color(230, 230, 230);
    private static Map<Integer, Color> COLORS = new Hashtable<Integer, Color>();
    public static final String FIELD_SEVERITY_STATS_COLOR = "color";
    public static final String FIELD_SEVERITY_STATS_NUMBER = "number";
    public static final String FIELD_SEVERITY_STATS_LEVEL = "level";
    private static TableFormat SEVERITY_STATS_FORMAT;
    public static final String ENVIRONMENT_ID = "id";
    public static final String ENVIRONMENT_CONTEXT = "context";
    public static final String ENVIRONMENT_EVENT = "event";
    public static final String ENVIRONMENT_LEVEL = "level";
    public static final String ENVIRONMENT_TIME = "time";
    public static final String ENVIRONMENT_ACKNOWLEDGEMENTS = "acknowledgements";
    public static final String ENVIRONMENT_ENRICHMENTS = "enrichments";
    public static final String ENVIRONMENT_VALUE = "value";
    public static final String EVENT_FIELD_CONTEXT = "context";
    public static final String EVENT_FIELD_NAME = "name";
    public static final String EVENT_FIELD_CREATIONTIME = "creationtime";

    public static long generateEventId() {
        return Math.abs(ThreadLocalRandom.current().nextLong());
    }

    public static List<EventDefinition> getEventDefinitions(ContextManager cm, String contextMask, String eventsMask, CallerController caller) {
        LinkedList<EventDefinition> events = new LinkedList<EventDefinition>();
        List<Context> contexts = ContextUtils.expandMaskToContexts(contextMask, cm, caller);
        for (Context context : contexts) {
            events.addAll(EventUtils.getEvents(context, eventsMask, caller));
        }
        return events;
    }

    public static List<EventDefinition> getEvents(Context<Context> context, String eventsMask, CallerController caller) {
        LinkedList<EventDefinition> events = new LinkedList<EventDefinition>();
        if (eventsMask.equals("*")) {
            for (EventDefinition ed : context.getEventDefinitions(caller)) {
                if (ed.getGroup() == null || "system".equals(ed.getGroup()) || ed.isDebuggingEvaluations()) continue;
                events.add(ed);
            }
        } else {
            EventDefinition ed = context.getEventDefinition(eventsMask);
            if (ed != null) {
                events.add(ed);
            }
        }
        return events;
    }

    public static boolean matchesToMask(String eventMask, EventDefinition ed) {
        if ("*".equals(eventMask)) {
            return ed.getGroup() != null && !"system".equals(ed.getGroup()) && !ed.isDebuggingEvaluations();
        }
        return ed.getName().equals(eventMask);
    }

    public static boolean matchesToMask(String eventMask, String event) {
        if ("*".equals(eventMask)) {
            return true;
        }
        return Util.equals(event, eventMask);
    }

    public static DataTable createSeverityStatisticsTable(int none, int notice, int info, int warning, int error, int fatal) {
        SimpleDataTable stats = new SimpleDataTable(SEVERITY_STATS_FORMAT);
        stats.addRecord().addInt(0).addInt(none).addColor(COLOR_NONE);
        stats.addRecord().addInt(1).addInt(notice).addColor(COLOR_NOTICE);
        stats.addRecord().addInt(2).addInt(info).addColor(COLOR_INFO);
        stats.addRecord().addInt(3).addInt(warning).addColor(COLOR_WARNING);
        stats.addRecord().addInt(4).addInt(error).addColor(COLOR_ERROR);
        stats.addRecord().addInt(5).addInt(fatal).addColor(COLOR_FATAL);
        return stats;
    }

    public static Color getEventColor(int level) {
        return COLORS.get(level);
    }

    public static Map<String, Object> getEnvironment(Event ev) {
        if (ev == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put(ENVIRONMENT_ID, ev.getId());
        environment.put("context", ev.getContext());
        environment.put(ENVIRONMENT_EVENT, ev.getName());
        environment.put("level", ev.getLevel());
        environment.put(ENVIRONMENT_TIME, ev.getCreationtime());
        environment.put(ENVIRONMENT_ACKNOWLEDGEMENTS, ev.getAcknowledgementsTable());
        environment.put(ENVIRONMENT_ENRICHMENTS, ev.getEnrichmentsTable());
        environment.put(ENVIRONMENT_VALUE, ev.getData());
        return environment;
    }

    static {
        COLORS.put(0, COLOR_NONE);
        COLORS.put(1, COLOR_NOTICE);
        COLORS.put(2, COLOR_INFO);
        COLORS.put(3, COLOR_WARNING);
        COLORS.put(4, COLOR_ERROR);
        COLORS.put(5, COLOR_FATAL);
        SEVERITY_STATS_FORMAT = new TableFormat();
        FieldFormat ff = FieldFormat.create("<level><I><D=" + Cres.get().getString("level") + ">");
        ff.setSelectionValues(EventLevel.getSelectionValues());
        SEVERITY_STATS_FORMAT.addField(ff);
        SEVERITY_STATS_FORMAT.addField(FieldFormat.create("<number><I><D=" + Cres.get().getString("efEventCount") + ">"));
        SEVERITY_STATS_FORMAT.addField(FieldFormat.create("<color><C><F=HI>"));
    }
}

