/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.event;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.DefaultFormatConverter;
import com.tibbo.aggregate.common.datatable.field.LongFieldFormat;
import com.tibbo.aggregate.common.datatable.validator.TableKeyFieldsValidator;
import com.tibbo.aggregate.common.event.EventEnrichmentRule;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.expression.function.DefaultFunctions;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class EventProcessingRule {
    private static final String FIELD_MASK = "mask";
    private static final String FIELD_EVENT = "event";
    private static final String FIELD_PREFILTER = "prefilter";
    private static final String FIELD_DEDUPLICATOR = "deduplicator";
    private static final String FIELD_QUEUE = "queue";
    private static final String FIELD_DUPLICATE_DISPATCHING = "duplicateDispatching";
    private static final String FIELD_PERIOD = "period";
    private static final String FIELD_ENRICHMENTS = "enrichments";
    public static final TableFormat FORMAT = new TableFormat();
    private String mask;
    private String event;
    private String prefilter = new String();
    private String deduplicator = new String();
    private int queue;
    private boolean duplicateDispatching;
    private long period;
    private List<EventEnrichmentRule> enrichments = new LinkedList<EventEnrichmentRule>();
    private Expression prefilterExpression;
    private Expression deduplicatorExpression;
    private long filtered;
    private long saved;
    private long duplicates;

    public EventProcessingRule() {
    }

    public EventProcessingRule(String mask, String event) {
        this.mask = mask;
        this.event = event;
    }

    public String getEvent() {
        return this.event;
    }

    public String getMask() {
        return this.mask;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public String getPrefilter() {
        return this.prefilter;
    }

    public void setPrefilter(String prefilter) {
        this.prefilter = prefilter;
        this.prefilterExpression = null;
    }

    public Expression getPrefilterExpression() {
        if (this.prefilterExpression == null) {
            this.prefilterExpression = this.prefilter != null && this.prefilter.length() > 0 ? new Expression(this.prefilter) : null;
        }
        return this.prefilterExpression;
    }

    public String getDeduplicator() {
        return this.deduplicator;
    }

    public void setDeduplicator(String deduplicator) {
        this.deduplicator = deduplicator;
        this.deduplicatorExpression = null;
    }

    public Expression getDeduplicatorExpression() {
        if (this.deduplicatorExpression == null) {
            this.deduplicatorExpression = this.deduplicator != null && this.deduplicator.length() > 0 ? new Expression(this.deduplicator) : null;
        }
        return this.deduplicatorExpression;
    }

    public List<EventEnrichmentRule> getEnrichments() {
        return this.enrichments;
    }

    public void setEnrichments(List<EventEnrichmentRule> enrichments) {
        this.enrichments = enrichments;
    }

    public int getQueue() {
        return this.queue;
    }

    public void setQueue(int queue) {
        this.queue = queue;
    }

    public boolean isDuplicateDispatching() {
        return this.duplicateDispatching;
    }

    public void setDuplicateDispatching(boolean duplicateDispatching) {
        this.duplicateDispatching = duplicateDispatching;
    }

    public void addFiltered() {
        ++this.filtered;
    }

    public void addSaved() {
        ++this.saved;
    }

    public void addDuplicate() {
        ++this.duplicates;
    }

    public long getFiltered() {
        return this.filtered;
    }

    public long getSaved() {
        return this.saved;
    }

    public long getDuplicates() {
        return this.duplicates;
    }

    public String toString() {
        return "EventProcessingRule [event=" + this.event + ", mask=" + this.mask + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventProcessingRule that = (EventProcessingRule)o;
        return Objects.equals(this.mask, that.mask) && Objects.equals(this.event, that.event);
    }

    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventProcessingRule that = (EventProcessingRule)o;
        return this.queue == that.queue && this.duplicateDispatching == that.duplicateDispatching && this.period == that.period && this.filtered == that.filtered && this.saved == that.saved && this.duplicates == that.duplicates && Objects.equals(this.mask, that.mask) && Objects.equals(this.event, that.event) && Objects.equals(this.prefilter, that.prefilter) && Objects.equals(this.deduplicator, that.deduplicator) && Objects.equals(this.enrichments, that.enrichments) && Objects.equals(this.prefilterExpression, that.prefilterExpression) && Objects.equals(this.deduplicatorExpression, that.deduplicatorExpression);
    }

    static {
        FORMAT.addTableValidator(new TableKeyFieldsValidator());
        FORMAT.addField(FieldFormat.create("<mask><S><F=NK><D=" + Cres.get().getString("conContextMask") + "><H=" + Cres.get().getString("eventProcessingRulesContextMask") + "><E=contextmask>"));
        FORMAT.addField(FieldFormat.create("<event><S><F=EK><V=<L=1 2147483647>><D=" + Cres.get().getString("efEventName") + "><H=" + Cres.get().getString("eventProcessingRulesEventName") + ">"));
        FORMAT.addField(FieldFormat.create("<prefilter><S><D=" + Cres.get().getString("efPrefilter") + "><H=" + Cres.get().getString("efPrefilterHelp") + "><E=" + "expression" + ">"));
        FORMAT.addField(FieldFormat.create("<deduplicator><S><D=" + Cres.get().getString("efDeduplicator") + "><H=" + Cres.get().getString("eventProcessingRulesDeduplicator") + "><E=" + "expression" + ">"));
        FORMAT.addField(FieldFormat.create("<queue><I><A=100><D=" + Cres.get().getString("efMemoryQueue") + "><H=" + Cres.get().getString("eventProcessingRulesRam") + ">"));
        FORMAT.addField(FieldFormat.create("<duplicateDispatching><B><D=" + Cres.get().getString("efDuplicateDispatching") + "><H=" + Cres.get().getString("eventProcessingRulesDeduplicationDispatching") + ">"));
        FORMAT.addField(FieldFormat.create("<period><L><A=8640000000><D=" + Cres.get().getString("confExpirationPeriod") + "><H=" + Cres.get().getString("eventProcessingRulesExpPeriod") + "><E=" + FIELD_PERIOD + "><O=" + LongFieldFormat.encodePeriodEditorOptions(3, 8) + ">"));
        FieldFormat ff = FieldFormat.create("<enrichments><T><D=" + Cres.get().getString(FIELD_ENRICHMENTS) + "><H=" + Cres.get().getString("eventProcessingRulesEnrichments") + ">");
        ff.setDefault(new SimpleDataTable(EventEnrichmentRule.FORMAT));
        FORMAT.addField(ff);
        String ref = "event#choices";
        String exp = "{utilities:eventsByMask('{mask}')}";
        FORMAT.addBinding(ref, exp);
        ref = "prefilter#options";
        exp = (Object)((Object)DefaultFunctions.EXPRESSION_EDITOR_OPTIONS) + "({" + FIELD_MASK + "}, {" + FIELD_EVENT + "}, " + 4 + ")";
        FORMAT.addBinding(ref, exp);
        ref = "deduplicator#options";
        exp = (Object)((Object)DefaultFunctions.EXPRESSION_EDITOR_OPTIONS) + "({" + FIELD_MASK + "}, {" + FIELD_EVENT + "}, " + 4 + ")";
        FORMAT.addBinding(ref, exp);
        ref = "queue#enabled";
        exp = "length({deduplicator}) > 0";
        FORMAT.addBinding(ref, exp);
        FORMAT.setReorderable(true);
        DataTableConversion.registerFormatConverter(new DefaultFormatConverter(EventProcessingRule.class, FORMAT));
    }
}

