/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.event;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.converter.DefaultFormatConverter;
import java.util.Date;

public class Enrichment {
    public static final String FIRST_OCCURRENCE = "firstOccurrence";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_VALUE = "value";
    public static final String FIELD_DATE = "date";
    public static final String FIELD_AUTHOR = "author";
    public static final TableFormat FORMAT = new TableFormat();
    private String name;
    private String value;
    private Date date;
    private String author;

    public Enrichment() {
    }

    public Enrichment(String name, String value, Date date, String author) {
        if (!ContextUtils.isValidContextName(name)) {
            throw new IllegalStateException("Illegal enrichment name: " + name);
        }
        this.name = name;
        this.value = value;
        this.date = date;
        this.author = author;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    static {
        FORMAT.addField("<name><S><D=" + Cres.get().getString(FIELD_NAME) + ">");
        FORMAT.addField("<value><S><D=" + Cres.get().getString(FIELD_VALUE) + ">");
        FORMAT.addField("<date><D><D=" + Cres.get().getString(FIELD_DATE) + ">");
        FORMAT.addField("<author><S><F=N><D=" + Cres.get().getString(FIELD_AUTHOR) + ">");
        FORMAT.setNamingExpression("print({}, \"{name} + '=' + {value} + ' (' + {date} + ', ' + {author} + ')'\", \"; \")");
        DataTableConversion.registerFormatConverter(new DefaultFormatConverter(Enrichment.class, FORMAT));
    }
}

