/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.event;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.AbstractContext;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextRuntimeException;
import com.tibbo.aggregate.common.context.EventData;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.event.ContextEventListener;
import com.tibbo.aggregate.common.event.ContextEventListenerInfo;
import com.tibbo.aggregate.common.event.EventHandlingException;
import com.tibbo.aggregate.common.expression.EvaluationException;
import com.tibbo.aggregate.common.expression.Evaluator;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;

public class ContextEventListenerSet {
    private final ConcurrentLinkedQueue<Object> filterListeners = new ConcurrentLinkedQueue();
    private final Map<String, Queue<Object>> fingerprintListeners = new ConcurrentHashMap<String, Queue<Object>>();
    private final ReentrantLock queueLock = new ReentrantLock();
    private ContextManager contextManager;
    private AbstractContext context;

    public ContextEventListenerSet(AbstractContext context) {
        this.context = context;
    }

    public ContextEventListenerSet(ContextManager contextManager) {
        this.contextManager = contextManager;
    }

    public void dispatch(Event event, EventDefinition eventDefinition, EventData eventData) {
        try {
            Collection fingerprintListeners;
            if (Log.CONTEXT_EVENTS.isDebugEnabled()) {
                Log.CONTEXT_EVENTS.debug((Object)("Dispatching event: " + event));
            }
            if ((fingerprintListeners = this.fingerprintListeners(event, eventDefinition)) != null) {
                this.dispatchEventToListeners(event, eventDefinition, eventData, fingerprintListeners);
            }
            this.dispatchEventToListeners(event, eventDefinition, eventData, this.filterListeners);
        }
        catch (Throwable ex) {
            Log.CONTEXT_EVENTS.error((Object)("Unexpected error occurred while dispatching event '" + event + "'"), ex);
        }
    }

    private void dispatchEventToListeners(final Event event, final EventDefinition eventDefinition, final EventData eventData, Collection listeners) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            Object ref = iterator.next();
            ContextEventListenerInfo li = ContextEventListenerSet.getListenerInfo(ref);
            if (li == null) {
                iterator.remove();
                continue;
            }
            final ContextEventListener eventListener = li.getListener();
            ContextManager contextManager = this.getContextManager();
            if (eventListener.isAsync() && contextManager != null && contextManager.getExecutorService() != null) {
                contextManager.getExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        ContextEventListenerSet.this.handleInListener(event, eventDefinition, eventListener, eventData);
                    }
                });
                continue;
            }
            this.handleInListener(event, eventDefinition, eventListener, eventData);
        }
    }

    private Collection fingerprintListeners(Event event, EventDefinition eventDefinition) throws SyntaxErrorException, EvaluationException {
        if (eventDefinition.getFingerprintExpression() != null) {
            ContextManager contextManager = this.getContextManager();
            if (contextManager != null) {
                Evaluator evaluator = new Evaluator(contextManager, contextManager.getCallerController());
                evaluator.setDefaultTable(event.getData());
                String fingerprint = evaluator.evaluateToString(eventDefinition.getCachedFingerprintExpression());
                return this.fingerprintListeners.get(fingerprint);
            }
            Log.CONTEXT_EVENTS.warn((Object)("Can't handle event with fingerprint because of no ContextManager: '" + event + "' "));
        }
        return null;
    }

    private void handleInListener(Event event, EventDefinition eventDefinition, ContextEventListener eventListener, EventData eventData) {
        try {
            eventData.registerHandleOffer();
            if (!eventListener.shouldHandle(event)) {
                if (Log.CONTEXT_EVENTS.isDebugEnabled()) {
                    Log.CONTEXT_EVENTS.debug((Object)("Listener '" + eventListener + "' does not want to handle event: " + event));
                }
                return;
            }
            eventData.registerHandleExecution();
            if (eventDefinition.isSessionBound()) {
                String listenerUserSessionId;
                Long eventSessionId = event.getSessionID();
                String eventUserSessionId = event.getUserSessionId();
                Long listenerSessionID = eventListener.getCallerController() != null && eventListener.getCallerController().getSessionIdCounter() != null ? eventListener.getCallerController().getSessionIdCounter() : -1L;
                String string = listenerUserSessionId = eventListener.getCallerController() != null ? eventListener.getCallerController().getSessionId() : null;
                if (eventUserSessionId != null && !eventUserSessionId.equals(listenerUserSessionId) || eventUserSessionId == null && eventSessionId != null && !eventSessionId.equals(listenerSessionID)) {
                    if (Log.CONTEXT_EVENTS.isDebugEnabled()) {
                        Log.CONTEXT_EVENTS.debug((Object)("Listener '" + eventListener + "' should not handle a session bound event: " + event));
                    }
                    return;
                }
            }
            if (Log.CONTEXT_EVENTS.isDebugEnabled()) {
                Log.CONTEXT_EVENTS.debug((Object)("Listener '" + eventListener + "' is going to handle event: " + event));
            }
            eventListener.handle(event, eventDefinition);
        }
        catch (Exception ex) {
            Log.CONTEXT_EVENTS.warn((Object)("Error handling event '" + event.toString() + "'"), (Throwable)ex);
        }
    }

    public boolean shouldHandle(Event event) {
        return this.applyForEachListenerAndReturnIfTrue((li, iterator) -> {
            try {
                return li.getListener().shouldHandle(event);
            }
            catch (EventHandlingException e) {
                Log.CONTEXT_EVENTS.debug((Object)("Unexpected error occurred while checking an event '" + event + "' in listener '" + li + "'"), (Throwable)e);
                throw e;
            }
        });
    }

    public void executeForEachListener(Consumer<ContextEventListenerInfo> action) {
        this.executeForEachQueue(queue -> this.executeForEachListenerInQueue((Queue)queue, action));
    }

    private void executeForEachQueue(Consumer<Queue> action) {
        action.accept(this.filterListeners);
        this.fingerprintListeners.values().forEach(action);
    }

    private boolean applyForEachListenerAndReturnIfTrue(ExceptionalFunction<ContextEventListenerInfo> action) {
        return this.applyForEachQueue(queue -> this.applyForEachListenerInQueue((Queue)queue, action, true), true);
    }

    private boolean applyForEachListener(ExceptionalFunction<ContextEventListenerInfo> action) {
        return this.applyForEachQueue(queue -> this.applyForEachListenerInQueue((Queue)queue, action, false), false);
    }

    private boolean applyForEachQueue(Function<Queue, Boolean> action, boolean returnOnTrue) {
        boolean result = action.apply(this.filterListeners);
        if (result && returnOnTrue) {
            return true;
        }
        for (Queue<Object> queue : this.fingerprintListeners.values()) {
            if (!(result |= action.apply(queue).booleanValue()) || !returnOnTrue) continue;
            return true;
        }
        return result;
    }

    private boolean applyForEachListenerInQueue(Queue queue, ExceptionalFunction<ContextEventListenerInfo> action, boolean returnOnTrue) {
        boolean result = false;
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            Object ref = iterator.next();
            ContextEventListenerInfo li = ContextEventListenerSet.getListenerInfo(ref);
            if (li == null) {
                iterator.remove();
                continue;
            }
            try {
                if (!(result |= action.apply(li, iterator)) || !returnOnTrue) continue;
                return true;
            }
            catch (EventHandlingException eventHandlingException) {
            }
        }
        return result;
    }

    private void executeForEachListenerInQueue(Queue queue, Consumer<ContextEventListenerInfo> action) {
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            Object ref = iterator.next();
            ContextEventListenerInfo li = ContextEventListenerSet.getListenerInfo(ref);
            if (li == null) {
                iterator.remove();
                continue;
            }
            action.accept(li);
        }
    }

    public boolean hasListeners() {
        return this.applyForEachListenerAndReturnIfTrue((li, iterator) -> true);
    }

    public int size() {
        AtomicInteger size = new AtomicInteger(0);
        this.executeForEachListener(li -> size.incrementAndGet());
        return size.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(ContextEventListener listener, boolean weak) {
        Queue<Object> listeners = this.filterListeners;
        String fingerprint = listener.getFingerprint();
        if (fingerprint != null) {
            try {
                this.queueLock.lock();
                listeners = this.fingerprintListeners.putIfAbsent(fingerprint, new ConcurrentLinkedQueue());
                if (listeners == null) {
                    this.fingerprintListeners.get(fingerprint).add(weak ? new WeakReference<ContextEventListener>(listener) : listener);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.queueLock.unlock();
            }
        }
        try {
            this.queueLock.lock();
            if (this.containsIn(listener, listeners)) {
                boolean bl = false;
                return bl;
            }
            listeners.add(weak ? new WeakReference<ContextEventListener>(listener) : listener);
            boolean bl = true;
            return bl;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    public boolean removeListener(ContextEventListener listener) {
        return this.applyForEachListenerAndReturnIfTrue((li, iterator) -> {
            if (li.getListener().equals(listener)) {
                iterator.remove();
                return true;
            }
            return false;
        });
    }

    public boolean contains(ContextEventListener listener) {
        return this.applyForEachQueue(queue -> this.containsIn(listener, (Queue)queue), true);
    }

    public void clear() {
        this.executeForEachQueue(Collection::clear);
    }

    private boolean containsIn(ContextEventListener listener, Queue listeners) {
        return this.applyForEachListenerInQueue(listeners, (contextEventListenerInfo, iterator) -> contextEventListenerInfo.getListener().equals(listener), true);
    }

    private static ContextEventListenerInfo getListenerInfo(Object ref) {
        if (ref instanceof ContextEventListener) {
            return new ContextEventListenerInfo((ContextEventListener)ref, false);
        }
        if (ref instanceof Reference) {
            ContextEventListener cel = (ContextEventListener)((Reference)ref).get();
            return cel != null ? new ContextEventListenerInfo(cel, true) : null;
        }
        throw new ContextRuntimeException("Unexpected reference: " + ref);
    }

    public ContextManager getContextManager() {
        return this.context != null ? this.context.getContextManager() : this.contextManager;
    }

    private static interface ExceptionalFunction<T> {
        public boolean apply(T var1, Iterator<T> var2) throws EventHandlingException;
    }
}

