/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.discovery;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.discovery.DiscoverableService;
import com.tibbo.aggregate.common.discovery.DiscoveryProvider;
import com.tibbo.aggregate.common.discovery.DiscoveryResultItem;
import java.util.List;

public abstract class DiscoverableServiceDefinition
implements Cloneable {
    private DiscoveryProvider discoveryProvider;
    private String name;
    private String description;
    private DataTable connectionOptions;
    private long discoveryTimeout;
    private int discoveryRetries;
    private boolean useService = true;
    private boolean isEnabledByDefault;

    public DiscoverableServiceDefinition(DiscoveryProvider discoveryProvider, String name, String description, DataTable connectionOptions, int defaultDiscoveryTimeout, int defaultDiscoveryRetries, boolean isEnabledByDefault) {
        this.discoveryProvider = discoveryProvider;
        this.name = name;
        this.description = description;
        this.setConnectionOptions(connectionOptions);
        this.setDiscoveryTimeout(defaultDiscoveryTimeout);
        this.setDiscoveryRetries(defaultDiscoveryRetries);
        this.isEnabledByDefault = isEnabledByDefault;
    }

    public abstract DiscoverableService createServiceInstance();

    public String getName() {
        return this.name;
    }

    public DataTable getConnectionOptions() {
        return this.connectionOptions;
    }

    public void setConnectionOptions(DataTable connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    public String getDescription() {
        return this.description;
    }

    public long getDiscoveryTimeout() {
        return this.discoveryTimeout;
    }

    public void setDiscoveryTimeout(long defaultDiscoveryTimeoutInt) {
        this.discoveryTimeout = defaultDiscoveryTimeoutInt;
    }

    public int getDiscoveryRetries() {
        return this.discoveryRetries;
    }

    public void setDiscoveryRetries(int defaultDiscoveryRetries) {
        this.discoveryRetries = defaultDiscoveryRetries;
    }

    public DiscoveryProvider getDiscoveryProvider() {
        return this.discoveryProvider;
    }

    public String deviceType(String addressStrings) {
        return "generic";
    }

    public Integer priority() {
        return 0;
    }

    public DiscoverableServiceDefinition clone() {
        try {
            return (DiscoverableServiceDefinition)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            Log.CORE.error((Object)"Unable to clone DiscoverableServiceDescription", (Throwable)ex);
            return null;
        }
    }

    public void setUseService(Boolean useService) {
        this.useService = useService;
    }

    public boolean isUseService() {
        return this.useService;
    }

    public boolean isEnabledByDefault() {
        return this.isEnabledByDefault;
    }

    public List<DiscoveryResultItem> check(String addressString, long timeoutMilliseconds, int triesCountInt) {
        return this.createServiceInstance().check(this, addressString, timeoutMilliseconds, triesCountInt);
    }

    public String toString() {
        return "DiscoverableServiceDefinition " + this.name + " [" + this.discoveryProvider + ", , timeout=" + this.discoveryTimeout + ", retries=" + this.discoveryRetries + ", options=" + this.connectionOptions + "]";
    }
}

