/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.device.sync;

import com.tibbo.aggregate.common.Cres;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SynchronizationResult {
    public static final int CODE_OK = 0;
    public static final int CODE_SUSPENDED = 10;
    public static final int CODE_DISABLED_BY_DEPENDENCY = 20;
    public static final int CODE_DECLINED_BY_DRIVER = 30;
    public static final int CODE_CONNECTION_FAILED = 40;
    public static final int CODE_INTERRUPTED = 50;
    public static final int CODE_DISCONNECTED = 60;
    public static final int CODE_ERROR = 70;
    public static final int CODE_MAINTENANCE = 80;
    private static Map<Integer, String> CODES = new HashMap<Integer, String>();
    private final int code;
    private String details;
    private Set<String> postponedVariables;

    public SynchronizationResult(int code) {
        if (!CODES.containsKey(code)) {
            throw new IllegalArgumentException("Unknown synchronization result code: " + code);
        }
        this.code = code;
    }

    public SynchronizationResult(int code, String details) {
        this(code);
        this.details = details;
    }

    public SynchronizationResult(int code, Set<String> postponedVariables) {
        this(code);
        this.postponedVariables = postponedVariables;
    }

    public boolean isSuccessful() {
        return this.code == 0;
    }

    public boolean isSuspended() {
        return this.code == 10;
    }

    public boolean isMaintenance() {
        return this.code == 80;
    }

    public int getCode() {
        return this.code;
    }

    public String toString() {
        return CODES.get(this.code) + (this.details != null ? ": " + this.details : "");
    }

    public Set<String> getPostponedVariables() {
        return this.postponedVariables;
    }

    static {
        CODES.put(0, Cres.get().getString("devSyncResOk"));
        CODES.put(10, Cres.get().getString("devSyncResSuspended"));
        CODES.put(20, Cres.get().getString("devSyncResDisabledByDependency"));
        CODES.put(30, Cres.get().getString("devSyncResDeclinedByDriver"));
        CODES.put(40, Cres.get().getString("devSyncResConnectionFailed"));
        CODES.put(50, Cres.get().getString("devSyncResInterrupted"));
        CODES.put(60, Cres.get().getString("devSyncResDisconnected"));
        CODES.put(70, Cres.get().getString("devSyncResError"));
        CODES.put(80, Cres.get().getString("devSyncResMaintenance"));
    }
}

