/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.device.sync;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.RequestController;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.context.VariableStatus;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.device.DeviceContext;
import com.tibbo.aggregate.common.device.DeviceException;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.device.sync.AbstractValueReader;
import com.tibbo.aggregate.common.device.sync.AbstractValueWriter;
import com.tibbo.aggregate.common.device.sync.SettingSynchronizationOptions;
import com.tibbo.aggregate.common.device.sync.ValueReader;
import com.tibbo.aggregate.common.device.sync.ValueWriter;
import java.util.Date;

public abstract class SynchronizationHandler {
    private static final String SERVER = Cres.get().getString("server");
    private SettingSynchronizationOptions synchronizationOptions;
    private DeviceContext deviceContext;
    private String variable;
    private VariableStatus customStatus;
    private boolean synchronizationEnabled = true;

    public void initialize(DeviceContext deviceContext, String variable, SettingSynchronizationOptions synchronizationOptions, boolean check) throws ContextException {
        this.deviceContext = deviceContext;
        this.variable = variable;
        this.synchronizationOptions = synchronizationOptions;
    }

    public void deinitialize() {
    }

    public void startSynchronization() throws DeviceException, ContextException {
    }

    public boolean isSynchronizationEnabled() {
        return this.synchronizationEnabled;
    }

    protected void setSynchronizationEnabled(boolean synchronizationEnabled) {
        this.synchronizationEnabled = synchronizationEnabled;
    }

    public DataTable readFromCache(CallerController caller, RequestController request) throws ContextException {
        return null;
    }

    public void writeToCache(CallerController caller, RequestController request, DataTable value) throws ContextException {
    }

    public ValueWriter createServerWriter() {
        return new AbstractValueWriter(SERVER){

            @Override
            public void write(DataTable value, CallerController callerController, RequestController requestController) throws ContextException, DeviceException, DisconnectionException {
                SynchronizationHandler.this.deviceContext.setVariable(SynchronizationHandler.this.getVariable(), callerController, requestController, value);
            }
        };
    }

    public ValueReader createServerReader() {
        return new AbstractValueReader(SERVER){

            @Override
            public DataTable read(CallerController callerController, RequestController requestController) throws ContextException, DeviceException, DisconnectionException {
                DataTable value = SynchronizationHandler.this.deviceContext.getVariable(SynchronizationHandler.this.getVariable(), callerController, requestController);
                if (value != null && value.isImmutable()) {
                    value = value.clone();
                }
                return value;
            }
        };
    }

    public Date getServerModificationTime() throws ContextException {
        return this.deviceContext.getSettingStatus(this.variable).getTime();
    }

    public Date getDeviceModificationTime() throws ContextException, DeviceException, DisconnectionException {
        return this.deviceContext.getDriver().getVariableModificationTime(this.getVariable());
    }

    public boolean isUpdatedOnTheServer(CallerController caller) throws ContextException {
        return this.deviceContext.getSettingStatus(this.variable).isUpdated();
    }

    public int getDirectionOverride() {
        return 0;
    }

    public VariableDefinition getPersistentDefinition(VariableDefinition vd) {
        return vd.clone();
    }

    public SettingSynchronizationOptions getSynchronizationOptions() {
        return this.synchronizationOptions;
    }

    protected DeviceContext getDeviceContext() {
        return this.deviceContext;
    }

    protected String getVariable() {
        return this.variable;
    }

    public VariableStatus getCustomStatus() {
        return this.customStatus;
    }

    public void setCustomStatus(VariableStatus customStatus) {
        this.customStatus = customStatus;
    }
}

