/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.device.sync;

import com.tibbo.aggregate.common.device.sync.SynchronizationHandler;
import com.tibbo.aggregate.common.expression.Expression;

public class SettingSynchronizationOptions
implements Cloneable {
    private int mode = 0;
    private Long updateHistoryStorageTime;
    private Long syncPeriod;
    private int historyRate;
    private int changeEventTimestamp;
    private String filter;
    private String master;
    private String condition;
    private boolean deliverUpdates = false;
    private boolean addPreviousValueToVariableUpdateEvent;
    private Expression filterExpression;
    private Expression conditionExpression;
    private SynchronizationHandler synchronizationHandler;
    private int synchronizationsCounter;
    private boolean enabled = true;

    public SettingSynchronizationOptions() {
    }

    public SettingSynchronizationOptions(Long syncPeriod) {
        this();
        this.syncPeriod = syncPeriod;
    }

    public SettingSynchronizationOptions(Long updateHistoryStorageTime, Long syncPeriod) {
        this(syncPeriod);
        this.updateHistoryStorageTime = updateHistoryStorageTime;
    }

    public SettingSynchronizationOptions(Long updateHistoryStorageTime, Long syncPeriod, int historyRate) {
        this(updateHistoryStorageTime, syncPeriod);
        this.historyRate = historyRate;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isAddPreviousValueToVariableUpdateEvent() {
        return this.addPreviousValueToVariableUpdateEvent;
    }

    public void setAddPreviousValueToVariableUpdateEvent(boolean addPreviousValueToVariableUpdateEvent) {
        this.addPreviousValueToVariableUpdateEvent = addPreviousValueToVariableUpdateEvent;
    }

    public Long getSyncPeriod() {
        return this.syncPeriod;
    }

    public void setSyncPeriod(Long syncPeriod) {
        this.syncPeriod = syncPeriod;
    }

    public String getMaster() {
        return this.master;
    }

    public void setMaster(String master) {
        this.master = master;
    }

    public Long getUpdateHistoryStorageTime() {
        return this.updateHistoryStorageTime;
    }

    public void setUpdateHistoryStorageTime(Long updateHistoryStorageTime) {
        this.updateHistoryStorageTime = updateHistoryStorageTime;
    }

    public int getHistoryRate() {
        return this.historyRate;
    }

    public void setHistoryRate(int historyRate) {
        this.historyRate = historyRate;
    }

    public int getChangeEventTimestamp() {
        return this.changeEventTimestamp;
    }

    public void setChangeEventTimestamp(int changeEventTimestamp) {
        this.changeEventTimestamp = changeEventTimestamp;
    }

    public String getFilter() {
        return this.filter;
    }

    public Expression getFilterExpression() {
        if (this.filterExpression == null && this.filter != null && this.filter.length() > 0) {
            this.filterExpression = new Expression(this.filter);
        }
        return this.filterExpression;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.filterExpression = null;
    }

    public String getCondition() {
        return this.condition;
    }

    public Expression getConditionExpression() {
        if (this.conditionExpression == null && this.condition != null && this.condition.length() > 0) {
            this.conditionExpression = new Expression(this.condition);
        }
        return this.conditionExpression;
    }

    public void setCondition(String condition) {
        this.condition = condition;
        this.conditionExpression = null;
    }

    public SynchronizationHandler getSynchronizationHandler() {
        return this.synchronizationHandler;
    }

    public void setSynchronizationHandler(SynchronizationHandler synchronizationHandler) {
        this.synchronizationHandler = synchronizationHandler;
    }

    public int getSynchronizationsCounter() {
        return this.synchronizationsCounter;
    }

    public void incrementSynchronizationsCounter() {
        ++this.synchronizationsCounter;
    }

    public boolean getDeliverUpdates() {
        return this.deliverUpdates;
    }

    public void setDeliverUpdates(boolean deliverUpdates) {
        this.deliverUpdates = deliverUpdates;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public SettingSynchronizationOptions clone() {
        try {
            SettingSynchronizationOptions clone = (SettingSynchronizationOptions)super.clone();
            clone.setSynchronizationHandler(null);
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public boolean allowsChangesOnly() {
        int hr = this.getHistoryRate();
        return hr == -1 || hr == -3 || hr == -6;
    }

    public boolean allowsErroneousValues() {
        int hr = this.getHistoryRate();
        return hr == -3 || hr == -6 || hr == -5 || hr == -7;
    }

    public boolean allowsOfflineValues() {
        int hr = this.getHistoryRate();
        return hr == -6 || hr == -4 || hr == -7;
    }

    public boolean hasCustomStatus() {
        if (this.synchronizationHandler != null) {
            return this.synchronizationHandler.getCustomStatus() != null;
        }
        return false;
    }
}

