/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.device.sync;

import com.tibbo.aggregate.common.device.sync.SynchronizationParameters;
import com.tibbo.aggregate.common.util.StringUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractSynchronizationParameters
implements SynchronizationParameters {
    public final String id;
    public final boolean shouldReadMetadata;
    public final boolean shouldPersistStatus;
    public final boolean shouldUseExtendedStatus;
    public final Integer directionOverride;
    public final Set<String> variables = new LinkedHashSet<String>();

    public AbstractSynchronizationParameters(String id, boolean shouldReadMetadata, boolean shouldPersistStatus, boolean shouldUseExtendedStatus) {
        this(id, shouldReadMetadata, shouldPersistStatus, shouldUseExtendedStatus, 0);
    }

    public AbstractSynchronizationParameters(String id, boolean shouldReadMetadata, boolean shouldPersistStatus, boolean shouldUseExtendedStatus, Integer directionOverride) {
        this.id = id;
        this.shouldReadMetadata = shouldReadMetadata;
        this.shouldPersistStatus = shouldPersistStatus;
        this.shouldUseExtendedStatus = shouldUseExtendedStatus;
        this.directionOverride = directionOverride;
    }

    @Override
    public boolean isShouldReadMetadata() {
        return this.shouldReadMetadata;
    }

    @Override
    public boolean isShouldPersistStatus() {
        return this.shouldPersistStatus;
    }

    @Override
    public boolean isShouldUseExtendedStatus() {
        return this.shouldUseExtendedStatus;
    }

    @Override
    public boolean isConnectOnly() {
        return false;
    }

    @Override
    public void addVariable(String variable) {
        this.variables.add(variable);
    }

    @Override
    public void removeVariable(String variable) {
        this.variables.remove(variable);
    }

    @Override
    public boolean hasMoreVariables() {
        return !this.variables.isEmpty();
    }

    @Override
    public boolean hasVariable(String variable) {
        return this.variables.contains(variable);
    }

    @Override
    public Set<String> getVariables() {
        return Collections.unmodifiableSet(this.variables);
    }

    @Override
    public boolean isFull() {
        return this.variables.isEmpty();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getDirectionOverride() {
        return this.directionOverride;
    }

    public String toString() {
        return "read metadata: " + (this.shouldReadMetadata ? "yes" : "no") + ", use extended status: " + (this.shouldUseExtendedStatus ? "yes" : "no") + ", settings: " + StringUtils.print(this.variables);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isConnectOnly() ? 1231 : 1237);
        result = 31 * result + this.directionOverride;
        result = 31 * result + this.variables.hashCode();
        result = 31 * result + (this.shouldPersistStatus ? 1231 : 1237);
        result = 31 * result + (this.shouldReadMetadata ? 1231 : 1237);
        result = 31 * result + (this.shouldUseExtendedStatus ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynchronizationParameters other = (SynchronizationParameters)obj;
        if (this.isConnectOnly() != other.isConnectOnly()) {
            return false;
        }
        if (Objects.equals(this.directionOverride, other.getDirectionOverride())) {
            return false;
        }
        if (!this.variables.equals(other.getVariables())) {
            return false;
        }
        if (this.shouldPersistStatus != other.isShouldPersistStatus()) {
            return false;
        }
        if (this.shouldReadMetadata != other.isShouldReadMetadata()) {
            return false;
        }
        return this.shouldUseExtendedStatus == other.isShouldUseExtendedStatus();
    }
}

